//
//  YHAIChatCustomFlowLayout.swift
//  galaxy
//
//  Created by Dufet on 2024/11/30.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAIChatCustomFlowLayout: UICollectionViewFlowLayout {

    let cellHeight = 33.0
    let verticalGap = 10.0
    let horizonalGap = 10.0
    var firstLineX = 20.0
    var secondLineX = 20.0
    let firstLineY = 10.0
    let secondLineY = 10.0 + 33.0 + 10.0

    var attributes: [UICollectionViewLayoutAttributes] = []
    
//    var dataSource:[String] = [] {
//        didSet {
//            attributes.removeAll()
//            firstLineX = 0.0
//            secondLineX = 0.0
//            for (index, text) in dataSource.enumerated() {
//                let attribute = UICollectionViewLayoutAttributes(forCellWith: IndexPath(row: index, section: 0))
//                if index % 2 == 0 { // 第一行的数据
//                    let size = self.getSize(index: index)
//                    attribute.frame = CGRectMake(firstLineX, verticalGap, size.width, size.height)
//                    firstLineX = firstLineX + attribute.frame.width + horizonalGap
//                    
//                } else { // 第二行的数据
//                    let size = self.getSize(index: index)
//                    attribute.frame = CGRectMake(secondLineX, verticalGap+cellHeight+verticalGap, size.width, size.height)
//                    secondLineX = secondLineX + attribute.frame.width + horizonalGap
//                }
//                attributes.append(attribute)
//            }
//            collectionView?.reloadData()
//        }
//    }
    
    var dataSource: [String] = [] {
        didSet {
            attributes.removeAll()
            firstLineX = 20.0
            secondLineX = 20.0
            for (index, text) in dataSource.enumerated() {
                let attribute = UICollectionViewLayoutAttributes(forCellWith: IndexPath(row: index, section: 0))
                let size = self.getSize(index: index)

                if firstLineX <= secondLineX {
                    attribute.frame = CGRect(x: firstLineX, y: firstLineY, width: size.width, height: size.height)
                    firstLineX = firstLineX + attribute.frame.width + horizonalGap
                    
                } else {
                    attribute.frame = CGRect(x: secondLineX, y: secondLineY, width: size.width, height: size.height)
                    secondLineX = secondLineX + attribute.frame.width + horizonalGap
                }
                attributes.append(attribute)
            }
            collectionView?.reloadData()
        }
    }
    
    override func layoutAttributesForItem(at indexPath: IndexPath) -> UICollectionViewLayoutAttributes? {
        if 0 <= indexPath.item, indexPath.item < attributes.count {
            return attributes[indexPath.item]
        }
        return nil
    }
    
    override func layoutAttributesForElements(in rect: CGRect) -> [UICollectionViewLayoutAttributes]? {
        return attributes
    }
    
    override var collectionViewContentSize: CGSize {
        guard let _ = collectionView else { return .zero }
        let width = max(firstLineX, secondLineX)
        let size = CGSize(width: width, height: cellHeight*2.0 + verticalGap)
        return size
    }
    
    func getSize(index: Int) -> CGSize {
        if 0 <= index, index < dataSource.count {
            let size = self.getwith(font: UIFont.PFSC_M(ofSize: 12), height: cellHeight, string: dataSource[index])
            let gap = 10.0
            let width = size.width + gap*2.0
            return CGSize(width: width, height: cellHeight)
        }
        return .zero
    }
    
    // 计算文字宽度大小
    func getwith(font: UIFont, height: CGFloat, string: String) -> CGSize {
        let size = CGSize.init(width: CGFloat(MAXFLOAT), height: height)
        let dic = [NSAttributedString.Key.font: font] // swift 4.2
        let strSize = string.boundingRect(with: size, options: [.usesLineFragmentOrigin], attributes: dic, context: nil).size
        return CGSize(width: ceil(strSize.width), height: strSize.height)
    }
}
