//
//  YHAIChatShadowView.swift
//  galaxy
//
//  Created by Dufet on 2024/11/30.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAIChatShadowView: UIView {

    override init(frame: CGRect) {
        super.init(frame: frame)
        setupShadow()
    }
        
    required init?(coder: NSCoder) {
        super.init(coder: coder)
        setupShadow()
    }
    
    private func setupShadow() {
        // 创建阴影路径
        let shadowPath = UIBezierPath(roundedRect: bounds, cornerRadius: 6)
        // 设置阴影属性
        layer.shadowPath = shadowPath.cgPath
        layer.shadowColor = UIColor(red: 0, green: 0, blue: 0, alpha: 0.08).cgColor
        layer.shadowOpacity = 1
        layer.shadowRadius = 6.0
        layer.shadowOffset = CGSize(width: 0, height: 4)
    }
        
    override func layoutSubviews() {
        super.layoutSubviews()
        // 确保在布局更新时更新阴影路径
        setupShadow()
    }
}

class YHAIFlowMessageShadowView: UIView {

    override init(frame: CGRect) {
        super.init(frame: frame)
        setupShadow()
    }
        
    required init?(coder: NSCoder) {
        super.init(coder: coder)
        setupShadow()
    }
    
    private func setupShadow() {
        // 创建阴影路径
        let shadowPath = UIBezierPath(roundedRect: bounds, cornerRadius: 6)
        // 设置阴影属性
        layer.shadowPath = shadowPath.cgPath
        layer.shadowColor = UIColor(red: 0, green: 0, blue: 0, alpha: 0.06).cgColor
        layer.shadowOpacity = 1
        layer.shadowRadius = 6.0
        layer.shadowOffset = CGSize(width: 0, height: 2)
    }
        
    override func layoutSubviews() {
        super.layoutSubviews()
        // 确保在布局更新时更新阴影路径
        setupShadow()
    }

}
