//
//  YHAIEvaluationAlertWebView.swift
//  galaxy
//
//  Created by Dufet on 2024/12/3.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAIEvaluationAlertWebView: UIView {

    var url: String = ""
    
    static func alertView(url: String) -> YHAIEvaluationAlertWebView {
        let v = YHAIEvaluationAlertWebView()
        return v
    }
    
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0x0F1214, alpha: 0.5)
        let tap = UITapGestureRecognizer(target: self, action: #selector(dismiss))
        view.addGestureRecognizer(tap)
        return view
    }()
    
    lazy var bottomView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.addSubview(leftBtn)
        view.addSubview(rightBtn)
        
        leftBtn.snp.makeConstraints { make in
            make.top.equalTo(8)
            make.left.equalTo(16)
            make.width.equalTo(rightBtn)
            make.right.equalTo(rightBtn.snp.left).offset(-10)
            make.height.equalTo(46)
        }
        rightBtn.snp.makeConstraints { make in
            make.top.equalTo(8)
            make.right.equalTo(-16)
            make.height.equalTo(46)
        }
        return view
    }()
    
    lazy var rightBtn: UIButton = {
        let btn = UIButton()
        btn.backgroundColor = .brandMainColor
        btn.setTitle("重新选择提升目标", for: .normal)
        btn.setTitleColor(.white, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
        btn.addTarget(self, action: #selector(didRightBtnClicked), for: .touchUpInside)
        btn.layer.cornerRadius = kCornerRadius3
        return btn
    }()
    
    lazy var leftBtn: UIButton = {
        let btn = UIButton()
        btn.backgroundColor = .init(hex: 0xF5F6F8)
        btn.setTitle("返回", for: .normal)
        btn.setTitleColor(.mainTextColor, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
        btn.addTarget(self, action: #selector(didLeftBtnClicked), for: .touchUpInside)
        btn.layer.cornerRadius = kCornerRadius3
        return btn
    }()
    
    lazy var webVC: YHH5WebViewVC = {
        let vc = YHH5WebViewVC()
        vc.url = ""
        vc.isNeedRefreshDataFlag = true
        vc.isFullScreenFlag = false
        return vc
    }()
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    static func alertView() -> YHAppVersionForceUpdateView {
        let alertView = YHAppVersionForceUpdateView(frame: UIScreen.main.bounds)
        return alertView
    }
    
    func createUI() {
        
        self.addSubview(blackMaskView)
        self.addSubview(bottomView)
        webVC.url = self.url
        webVC.view.frame = CGRect(x: 0, y: 100, width: KScreenWidth, height: KScreenHeight-100-98)
        self.addSubview(webVC.view)
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        bottomView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(98)
        }
        
        webVC.view.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(100)
        }
    }
    
    @objc func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        DispatchQueue.main.async {
            self.removeFromSuperview()
        }
    }
    
    @objc func didLeftBtnClicked() {
        dismiss()
    }
    
    @objc func didRightBtnClicked() {
        dismiss()
        YHMyNewSchemeViewController.shared.goToSchemePage()
    }
}
