//
//  YHAIEvaluationWebView.swift
//  galaxy
//
//  Created by Dufet on 2024/12/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAIEvaluationWebView: UIView {
    
    var finishBlock: (([String: Any]) -> Void)?
    
    lazy var webVC: YHH5WebViewVC = {
        let vc = YHH5WebViewVC()
        vc.isFullScreenFlag = true
        vc.isHideNavigationBar = true
        vc.evaluationResultCallback = {
            [weak self] dict in
            guard let self = self else { return }
            finishBlock?(dict)
            self.dismiss()
        }
        return vc
    }()
    
    static func webView(url: String, finishBlock: (([String: Any]) -> Void)?) -> YHAIEvaluationWebView {
        let view = YHAIEvaluationWebView(frame: UIScreen.main.bounds, url: url)
        view.webVC.url = url
        view.finishBlock = finishBlock
        return view
    }
    
    func show() {
        
        self.frame = CGRect(x: 0, y: KScreenHeight, width: KScreenWidth, height: KScreenHeight)
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
        UIView.animate(withDuration: 0.25, delay: 0, options: .curveEaseOut, animations: {
            self.frame = CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight)
        }) { _ in
            self.frame = CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight)
        }
    }
    
    func dismiss() {
        
        UIView.animate(withDuration: 0.25, delay: 0, options: .curveEaseOut, animations: {
            self.frame = CGRect(x: 0, y: KScreenHeight, width: KScreenWidth, height: KScreenHeight)
        }) { _ in
            self.removeFromSuperview()
        }
    }
    
    init(frame: CGRect, url: String) {
        super.init(frame: frame)
        self.webVC.url = url
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        self.addSubview(webVC.view)
        webVC.view.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
    }
}
