//
//  YHCardMessageCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHAIJumpType: Int {
    case common = 0
    case evaluation = 1
}

enum YHAIJumpMode: Int {
    case web = 1
    case app = 2
    case robot = 3
}

class YHAIJumpPageTool {
    
    // mode = 0 // 1 web 2 原生页面 3 AI_Robot
    // type = 0 // 0 普通 1 测评
    
    static func jumpPageWithType(_ type: YHAIJumpType = .common, mode: Int, path: String, block: (([String: Any]) -> Void)?) {
        
        printLog("type:\(type) mdde:\(mode) path:\(path)")
        
        if mode == YHAIJumpMode.web.rawValue { //
            if !path.isEmpty {
                
                var url = path
                if YHLoginManager.shared.isLogin() {
                    let token = YHLoginManager.shared.h5Token
                    url = path + "?param=" + token
                    let urlHasParam = String.hasQueryParameters(urlString: path)
                    if urlHasParam {
                        url = path + "&param=" + token
                    }
                } else {
                    url = path
                }
                
                // 2.增加导航栏高度
                var resultUrl = url
                if !url.contains("navigationH=") {
                    resultUrl = url + "?navigationH=\(k_Height_NavigationtBarAndStatuBar)"
                    if url.contains("?") {
                        resultUrl = url + "&navigationH=\(k_Height_NavigationtBarAndStatuBar)"
                    }
                }
                
                if type == .evaluation {
                    YHAIEvaluationWebView.webView(url: resultUrl, finishBlock: block).show()

                } else {
                    
                    let vc = YHH5WebViewVC()
                    vc.url = resultUrl
                    vc.evaluationResultCallback = block
                    UIViewController.current?.navigationController?.pushViewController(vc, animated: true)
                }
            }
            
        } else if mode == YHAIJumpMode.app.rawValue {
            // customerVoice -> APP客户心声  productList -> APP-首页银河甄选
            if path == YHAIJumpPageType.customerHeart.rawValue {
                // 客户心声
                let vc = YHOtherServiceViewController()
                vc.classID = 5
                UIViewController.current?.navigationController?.pushViewController(vc)
                
            } else if path == YHAIJumpPageType.galaxySelect.rawValue {
                // 银河甄选
                let vc = YHSelectViewController()
                vc.hideFlag = false
                UIViewController.current?.navigationController?.pushViewController(vc, animated: true)
                
            } else if path == YHAIJumpPageType.appServiceTab.rawValue {
                // 服务页
                UIViewController.current?.navigationController?.popToRootViewController(animated: false)
                goTabBarBy(tabType: .service)
            }
            
        } else if mode == YHAIJumpMode.robot.rawValue {
            
        }
    }
}

class YHCardMessageCell: UITableViewCell {

    var updateBlock: (() -> Void)?

    static let cellReuseIdentifier = "YHCardMessageCell"
    
    var evaluationResultCallback: ((Dictionary<String, Any>) -> Void)?

    var cardListModel = YHAIListInfoModel() {
        didSet {
            iconImgView.sd_setImage(with: URL(string: cardListModel.icon))
            titleLabel.text = cardListModel.title
            subtitleLabel.text = cardListModel.description
            bottomBtn.setTitle(cardListModel.btnText, for: .normal)
            listView.removeSubviews()
            
            var lastItemView: YHAICardItemView?
            for (index, item) in cardListModel.list.enumerated() {
                let productView = YHAICardItemView()
                productView.updateBlock = {
                    [weak self] in
                    guard let self = self else { return }
                    self.updateBlock?()
                }
                productView.evaluationResultCallback = {
                    [weak self] dict in
                    guard let self = self else { return }
                    self.evaluationResultCallback?(dict)
                }
                productView.cardModel = item
                listView.addSubview(productView)
                productView.snp.makeConstraints { make in
                    make.left.right.equalToSuperview()
                    if let lastItemView = lastItemView {
                        make.top.equalTo(lastItemView.snp.bottom)

                    } else {
                        make.top.equalTo(0)
                    }
                    if index == cardListModel.list.count-1 {
                        make.bottom.equalTo(0)
                    }
                }
                lastItemView = productView
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }

    var whiteContentView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.layer.cornerRadius = 12.0
        v.clipsToBounds = true
        return v
    }()
    
    lazy var iconImgView: UIImageView = {
        let v = UIImageView(image: UIImage(named: ""))
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_B(ofSize: 16)
        lable.text = "港小宝"
        return lable
    }()
    
    lazy var subtitleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.init(hex: 0x8993A2)
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_R(ofSize: 12)
        lable.text = "为您推荐以下优才产品"
        return lable
    }()
    
    lazy var listView: UIView = {
        let v = UIView()
        return v
    }()
    
    lazy var bottomBtn: UIButton = {
        let btn = UIButton()
        btn.setTitle("", for: .normal)
        btn.setTitleColor(UIColor.brandMainColor, for: .normal)
        btn.backgroundColor = .init(UIColor(hex: 0xEBF0F9))
        btn.titleLabel?.font = .PFSC_M(ofSize: 14)
        btn.layer.cornerRadius = 6.0
        btn.addTarget(self, action: #selector(didBottomButtonClicked), for: .touchUpInside)
        return btn
    }()
    
    lazy var shadowView: YHAIChatShadowView = {
        let v = YHAIChatShadowView()
        return v
    }()
    
    @objc func didBottomButtonClicked() {
        
        UIApplication.shared.yhKeyWindow()?.endEditing(true)

        var type = YHAIJumpType.common
        if cardListModel.isEvaluation() {
            type = YHAIJumpType.evaluation
        }
        YHAIJumpPageTool.jumpPageWithType(type, mode: cardListModel.redirectMode, path: cardListModel.redirectPath) {
            dict in
            self.evaluationResultCallback?(dict)
        }
    }
        
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        contentView.addSubview(shadowView)
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(iconImgView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(subtitleLabel)
        whiteContentView.addSubview(listView)
        whiteContentView.addSubview(bottomBtn)
        
        shadowView.snp.makeConstraints { make in
            make.edges.equalTo(whiteContentView)
        }

        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(16)
            make.bottom.equalTo(0)
        }
        
        iconImgView.snp.makeConstraints { make in
            make.width.height.equalTo(36)
            make.top.equalTo(20)
            make.left.equalTo(16)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(iconImgView)
            make.left.equalTo(iconImgView.snp.right).offset(8)
            make.height.equalTo(24)
            make.right.equalTo(-16)
        }
        
        subtitleLabel.snp.makeConstraints { make in
            make.left.equalTo(titleLabel)
            make.top.equalTo(titleLabel.snp.bottom).offset(0)
            make.height.equalTo(20)
            make.right.equalTo(-16)
        }
        
        listView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(subtitleLabel.snp.bottom).offset(10)
        }
        
        bottomBtn.snp.makeConstraints { make in
            make.top.equalTo(listView.snp.bottom).offset(0)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(-16)
            make.height.equalTo(44)
        }
    }
}
