//
//  YHProductItemView.swift
//  galaxy
//
//  Created by Dufet on 2024/11/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHProductItemView: UIView {
    
    var productModel = YHAIListItemModel() {
        didSet {
            iconImgView.sd_setImage(with: URL(string: productModel.cover), placeholderImage: UIImage(named: "global_default_image"))
            titleLabel.text = productModel.title
            let aa: ASAttributedString = .init("￥", .font(UIFont(name: "DINAlternate-Bold", size: 14)!), .foreground(UIColor.mainTextColor))
            let bb: ASAttributedString = .init("\(productModel.discountPrice)", .font(UIFont(name: "DINAlternate-Bold", size: 20)!), .foreground(UIColor.mainTextColor))
            let cc: ASAttributedString = .init(" ", .font(UIFont(name: "DINAlternate-Bold", size: 14)!), .foreground(UIColor.init(hex: 0xB9C1CC)))
            let dd: ASAttributedString = .init("￥\(productModel.originalPrice)", .font(UIFont(name: "DINAlternate-Bold", size: 14)!), .foreground(UIColor.init(hex: 0xB9C1CC)), .strikethrough(.single))
            
            if productModel.discountPrice == productModel.originalPrice {
                priceLabel.attributed.text = aa+bb+cc
            } else {
                priceLabel.attributed.text = aa+bb+cc+dd
            }
            
            tagContentView.removeSubviews()
            var lastTagView: YHProductTagView?
            for tagModel in productModel.tags {
                let v = YHProductTagView()
                v.tagModel = tagModel
                tagContentView.addSubview(v)
                v.snp.makeConstraints { make in
                    make.top.bottom.equalTo(0)
                    if let lastTagView = lastTagView {
                        make.left.equalTo(lastTagView.snp.right).offset(4)
                    } else {
                        make.left.equalTo(0)
                    }
                }
                lastTagView = v
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var bottomLineView: UIView = {
        let v = UIView()
        v.backgroundColor = .init(hex: 0xE9ECF0)
        return v
    }()
    
    lazy var iconImgView: UIImageView = {
        let v = UIImageView(image: UIImage(named: ""))
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_M(ofSize: 16)
        return lable
    }()
    
    lazy var tagContentView: UIView = {
        let v = UIView()
        return v
    }()

    lazy var priceLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        let aa: ASAttributedString = .init("￥", .font(UIFont(name: "DINAlternate-Bold", size: 14)!), .foreground(UIColor.mainTextColor))
        let bb: ASAttributedString = .init("0", .font(UIFont(name: "DINAlternate-Bold", size: 20)!), .foreground(UIColor.mainTextColor))
        let cc: ASAttributedString = .init(" ￥0", .font(UIFont(name: "DINAlternate-Bold", size: 14)!), .foreground(UIColor.init(hex: 0xB9C1CC)), .strikethrough(.single))
        label.attributed.text = aa+bb+cc
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func didClickProductItem() {

        UIApplication.shared.yhKeyWindow()?.endEditing(true)
        if let configModel = YHConfigManager.shared.reqVM.configModel, configModel.is_integral_open {
            YHAIJumpPageTool.jumpPageWithType(mode: productModel.redirectMode, path: productModel.redirectPath) {
                _ in
            }
        }
    }
    
    func createUI() {
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(didClickProductItem))
        self.addGestureRecognizer(tap)
        
        self.addSubview(iconImgView)
        self.addSubview(titleLabel)
        self.addSubview(tagContentView)
        self.addSubview(priceLabel)
        self.addSubview(bottomLineView)
        
        iconImgView.snp.makeConstraints { make in
            make.width.height.equalTo(80)
            make.left.equalTo(0)
            make.top.equalTo(20)
            make.bottom.equalTo(-20)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(iconImgView.snp.right).offset(12)
            make.right.equalTo(0)
            make.top.equalTo(iconImgView)
            make.height.equalTo(22)
        }
        
        tagContentView.snp.makeConstraints { make in
            make.left.equalTo(titleLabel)
            make.right.equalTo(0)
            make.height.equalTo(16)
            make.top.equalTo(titleLabel.snp.bottom).offset(4)
        }
        
        priceLabel.snp.makeConstraints { make in
            make.left.equalTo(titleLabel)
            make.right.equalTo(0)
            make.bottom.equalTo(iconImgView)
            make.height.equalTo(20)
        }
        
        bottomLineView.snp.makeConstraints { make in
            make.left.equalTo(iconImgView)
            make.right.equalTo(0)
            make.height.equalTo(0.5)
            make.bottom.equalTo(0)
        }
    }
}

class YHProductTagView: UIView {
    
    var tagModel: YHProductTag = YHProductTag() {
        didSet {
            tagLabel.text = tagModel.text
            if !tagModel.color.isEmpty {
                self.layer.borderColor = UIColor(hexString: tagModel.color, transparency: 0.3)?.cgColor
                tagLabel.textColor = UIColor(hexString: tagModel.color)
            } else {
                self.layer.borderColor = UIColor.mainTextColor(alpha: 0.3).cgColor
                tagLabel.textColor = UIColor.mainTextColor
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var tagLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .center
        lable.font = UIFont.PFSC_R(ofSize: 10)
        return lable
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    func createUI() {
        
        self.layer.borderColor = UIColor.mainTextColor.cgColor
        self.layer.borderWidth = 0.5
        self.clipsToBounds = true
        self.addSubview(tagLabel)
        tagLabel.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(5)
            make.right.equalTo(-5)
        }
    }
}
