//
//  YHRecommendTextMessageCell.swift
//  galaxy
//
//  Created by Dufet on 2024/12/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHRecommendTextMessageCell: UITableViewCell {

    static let cellReuseIdentifier = "YHRecommendTextMessageCell"
    
    var messageClick: ((String) -> Void)?
    
    var message: YHAIChatMessage = YHAIChatMessage() {
        
        didSet {
            messageLabel.text = message.body.contentText
            whiteContentView.backgroundColor = .white
            messageLabel.textColor = .mainTextColor
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var whiteContentView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.layer.cornerRadius = 12.0
        v.clipsToBounds = true
        let tap = UITapGestureRecognizer(target: self, action: #selector(didMessageClicked))
        v.addGestureRecognizer(tap)
        
        let longPress = UILongPressGestureRecognizer(target: self, action: #selector(didCopyTextLongGesture(_:)))
        v.addGestureRecognizer(longPress)
        return v
    }()
    
    lazy var messageLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_M(ofSize: 12)
        lable.numberOfLines = 0
        return lable
    }()
    
    @objc func didCopyTextLongGesture(_ sender: UIGestureRecognizer) {
        let text = message.body.contentText
        if sender.state == .began {
            UIPasteboard.general.string = text
            YHHUD.flash(message: "复制成功")
        }
    }
    
    lazy var shadowView: YHAIChatShadowView = {
        let v = YHAIChatShadowView()
        return v
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        contentView.addSubview(shadowView)
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(messageLabel)
        
        shadowView.snp.makeConstraints { make in
            make.edges.equalTo(whiteContentView)
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.lessThanOrEqualTo(-20)
            make.top.equalTo(10)
            make.bottom.equalTo(0)
        }
        
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(10)
            make.bottom.equalTo(-10)
        }
    }
    
    @objc func didMessageClicked() {
        
        UIApplication.shared.yhKeyWindow()?.endEditing(true)
        let text = message.getText()
        messageClick?(text)
    }
}
