//
//  YHAliYunLogManager.swift
//  galaxy
//
//  Created by edy on 2024/10/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AliyunLogProducer

enum YHAliYunLogKey: String {
    
    case moduleName = "moduleName"  // 模块名
    case mobile = "mobile" // 当前登录用户的手机号码
    case remark = "remark"  // 可以随意上传内容
    case timestamp = "timestamp" // 时间戳
    case app_platform = "app_platform" // 系统、平台
    case app_version = "app_version" // app版本号
    case app_channel = "app_channel"
    case app_phoneModel = "app_phoneModel" // 手机型号
    case os_version_name = "os_version_name" // 操作系统版本号
}

enum YHModuleNameValue: String {
    case networkDataType = "networkDataType"     // 网络数据
    case h5InteractionType = "h5InteractionType" // 与H5交互相关
    case clickType = "clickType" // 用户点点击事件
    case logTypeError = "logTypeError" // log失败状态
}

class YHAliYunLogManager {
    
    static let SLS_ENDPOINT = "cn-shenzhen.log.aliyuncs.com"
    static let SLS_PROJECT_DEV = "dev-yinhe-app"
    static let SLS_PROJECT_RELEASE = "release-yinhe-app"
    static let SLS_LOG_STORE = "yinhe_logstore"
    static let SLS_KEY = "LTAI5tRiRFQGiM3DtDVpjHWr"
    static let SLS_SECRET = "f9Uc3LNhxDWwlBS7rmdg4UPCTUL57M"
    
    static let shared = createManager()
    private var config: LogProducerConfig?
    private var client: LogProducerClient?
    
    static private func createManager() -> YHAliYunLogManager {
        
        let manager = YHAliYunLogManager()
#if DEBUG
        let projectName = SLS_PROJECT_DEV
#elseif TESTENV
        let projectName = SLS_PROJECT_DEV
#elseif UATENV
        let projectName = SLS_PROJECT_DEV
#else
        let projectName = SLS_PROJECT_RELEASE
#endif
        
        let config = LogProducerConfig(endpoint: SLS_ENDPOINT,
                                       project: projectName,
                                       logstore: SLS_LOG_STORE,
                                       accessKeyID: SLS_KEY,
                                       accessKeySecret: SLS_SECRET)
        // 设置日志主题
//        config?.setTopic("example_topic")
        // 设置日志来源。
//        config?.setSource("your new-source")
        // 设置tag信息，此tag信息将被附加在每条日志上。
//        config?.addTag("example", value: "example_tag")
        // 是否丢弃过期日志。0表示不丢弃，把日志时间修改为当前时间; 1表示丢弃。默认值为1。
        config?.setDropDelayLog(1)
        // 是否丢弃鉴权失败的日志，0表示不丢弃，1表示丢弃。默认值为0。
        config?.setDropUnauthorizedLog(0)
        manager.config = config
        manager.client = LogProducerClient(logProducerConfig: config!)
        return manager
    }
    
    func addLog(_ log: Log?) {
        guard let log = log else {
            print("Log is nil, not adding.")
            return
        }
        
        client?.add(log)
    }
    
    func addLog() {
        let log = Log()
        log.putContent("银河移动开发组效忠宣言", value: "坚决拥护龙的领导，团结在龙的周围，凡是龙的决策，我们都坚决维护，凡是龙的指示，我们都始终不渝地遵循")
        client?.add(log)
    }
    
    func addModuleName(_ moduleName: YHModuleNameValue, remark: String) {
        let log = Log()
        addCommonInfoLog(log)
        log.putContent(YHAliYunLogKey.moduleName.rawValue, value: moduleName.rawValue)
        log.putContent(YHAliYunLogKey.remark.rawValue, value: remark)
        client?.add(log)
    }
    
    func addModuleName(_ moduleName: YHModuleNameValue, remark: [AnyHashable: Any]) {
        let log = Log()
        addCommonInfoLog(log)
        log.putContent(YHAliYunLogKey.moduleName.rawValue, value: moduleName.rawValue)
        log.putContent(YHAliYunLogKey.remark.rawValue, dictValue: remark)
        client?.add(log)
    }
    
    private func addCommonInfoLog(_ log: Log) {
        
        // 当前登录用户的手机号码
        if YHLoginManager.shared.isLogin(), let mobile = YHLoginManager.shared.userModel?.mobile, !mobile.isEmpty {
            log.putContent(YHAliYunLogKey.mobile.rawValue, value: mobile)
        }
        // 系统、平台
        log.putContent(YHAliYunLogKey.app_platform.rawValue, value: "iOS")
        // app版本号
        log.putContent(YHAliYunLogKey.app_version.rawValue, value: UIDevice.appVersion())
        // app渠道号
        log.putContent(YHAliYunLogKey.app_channel.rawValue, value: "appStore")
        // 手机型号
        log.putContent(YHAliYunLogKey.app_phoneModel.rawValue, value: UIDevice.iPhoneModelName())
        // 操作系统版本号
        log.putContent(YHAliYunLogKey.os_version_name.rawValue, value: UIDevice.iPhoneVersion())
        // 当前时间戳
        log.putContent(YHAliYunLogKey.timestamp.rawValue, value: String(Date().timeIntervalSince1970))
    }
}
