//
//  YHTencentDeskManager.swift
//  galaxy
//
//  Created by alexzzw on 2025/4/30.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import IQKeyboardManagerSwift
import UIKit
import TUICore

class YHTencentDeskManager: NSObject {
    
    static let shared = YHTencentDeskManager()
    
    private lazy var viewModel: YHButlerServiceViewModel = YHButlerServiceViewModel()
    
    private override init() {
        super.init()
        NotificationCenter.default.addObserver(self, selector: #selector(loginSuccess), name: YhConstant.YhNotification.didLoginSuccessNotifiction, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(logoutSuccess), name: YhConstant.YhNotification.didLogoutSuccessNotifiction, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(didRevUatParam), name: YhConstant.YhNotification.didRevUatParam, object: nil)
        if isUatAllowed() {
            loginSDK()
        }
    }
    
    deinit {
        NotificationCenter.default.removeObserver(self)
    }
    
    func loginIM() {
        let users: [String: String] = ["1": "eJyrVgrxCdYrSy1SslIy0jNQ0gHzM1NS80oy0zLBwoZQweKU7MSCgswUJStDMwMDAwtTY0MTiExqRUFmUSpQ3NTU1AgoBREtycwFiZmbmBtZmhsZmEJNyUwHmhnoU*6YmBJZEaMfWmyWbeDuYhRu6RaSkuQco58fllQQ7J9jYFmcFejnW6GdZ2GrVAsAYeYv3A__", "3": "eJyrVgrxCdYrSy1SslIy0jNQ0gHzM1NS80oy0zLBwsZQweKU7MSCgswUJStDMwMDAwtTY0MTiExqRUFmUSpQ3NTU1AgoBREtycwFiZmbmJlZmJoZGENNyUwHmlnoHObvGx4cmZjvnF5VVhmU4ZvtX2QZZOpZ4Ztv7OJmamSZ5B4So19ualyZbKtUCwBFAi-S", "15272": "eJyrVgrxCdYrSy1SslIy0jNQ0gHzM1NS80oy0zLBwoamRuZGUInilOzEgoLMFCUrQzMDAwMLU2NDE4hMakVBZlEqUNzU1NQIKAURLcnMBYmZm5gbm1uYWhpCTclMB5pbVR6Z6KXtZxlsnJvt5Btaqm0YaRmUH1Qclh1u6OOaahienFdaku7jZljsaKtUCwCa0DA7", "2": "eJyrVgrxCdYrSy1SslIy0jNQ0gHzM1NS80oy0zIhwlDB4pTsxIKCzBQlK0MzAwMDC1NjQxOITGpFQWZRKlDc1NTUCCgFES3JzAWJmZuYmxsbGVsaQU3JTAeaaVie7WMQ5GnkVZllkeVVVeXnVOBXGVxg5GThYlRkahheZBae6BgYXurp52urVAsAAVUvGg__"]
        let key = "2"
        let success: TSucc? = {
            printLog("loginIM success")
            _ = YHTUIMessageListManager.shared
        }
        let failure: TFail? = { code, msg in
            printLog("loginIM failure: code: \(code) msg: \(msg ?? "")")
        }
        TUILogin.login(YhConstant.TencentIMSDKInfo.sdkAppID, userID: key, userSig: users[key] ?? "", succ: success, fail: failure)
    }
    
    func loginSDK() {
        guard let userId = YHLoginManager.shared.userModel?.id, userId.count > 0 else {
            return
        }
        
        viewModel.getUsersig { [weak self] success, _ in
            guard let self = self else {
                return
            }
            if success == true {
                let userSig = self.viewModel.userSig ?? ""
                let success: TSucc? = {
                    printLog("loginIM success")
                    _ = YHTUIMessageListManager.shared
                }
                let failure: TFail? = { code, msg in
                    printLog("loginIM failure: code: \(code) msg: \(msg ?? "")")
                }
                TUILogin.login(YhConstant.TencentIMSDKInfo.sdkAppID, userID: userId, userSig: userSig, succ: success, fail: failure)
            }
        }
        
    }
}

extension YHTencentDeskManager {
    // MARK: - 常用公开方法
    
    /// 灰度打开
    func isUatAllowed() -> Bool {
        let allowed = YHUatHelper.shared.getUatModuleStatusBy(module: .QiYu_Service) == 1
        return allowed
    }
    
    @objc private func didRevUatParam() {
        guard isUatAllowed() else {
            return
        }
        loginSDK()
    }
    
    @objc private func loginSuccess() {
        guard isUatAllowed() else {
            return
        }
        loginSDK()
    }
    
    @objc private func logoutSuccess() {
        let success: TSucc? = {
            printLog("logout success")
            _ = YHTUIMessageListManager.shared
        }
        let failure: TFail? = { code, msg in
            printLog("logout failure: code: \(code) msg: \(msg ?? "")")
        }
        TUILogin.logout(success, fail: failure)
    }
}
