//
//  YHApplyActivityResultViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

/*
 报名结果页
 */
class YHApplyActivityResultViewController: YHBaseViewController {
    
    var isSuccessFlag: Bool = false
    var messageTips: String = ""
    var activityTravelId: String = ""
    var activityName: String = ""
    
    lazy var statusImageV: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "activity_apply_result_success")
        view.contentMode = .scaleAspectFill
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .center
        lable.font = UIFont.PFSC_M(ofSize: 18)
        lable.text = "报名成功"
        lable.numberOfLines = 0
        return lable
    }()
    
    lazy var nameLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor30
        lable.textAlignment = .center
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.text = "已报名成功活动【哈佛爸爸线下教育沙龙】，记得准时参加哦"
        lable.numberOfLines = 0
        return lable
    }()
    
    lazy var submitButton: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 16)
        button.contentHorizontalAlignment = .center
        button.setTitle("查看行程单", for: .normal)
        button.setTitle("查看行程单", for: .highlighted)
        button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
        button.setTitleColor( UIColor(hex: 0xffffff), for: .highlighted)
        button.layer.cornerRadius = kCornerRadius3
        button.addTarget(self, action: #selector(clickSubmitBtn), for: .touchUpInside)
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.backgroundColor = .brandMainColor
        return button
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
    }
}

extension YHApplyActivityResultViewController {
    func setupUI() {
        gk_navigationBar.isHidden = false
        gk_navigationBar.backgroundColor = .clear
        gk_navTitle = "报名结果"
        
        view.backgroundColor = UIColor.white
        
        view.addSubview(statusImageV)
        statusImageV.snp.makeConstraints { make in
            make.top.equalTo(180)
            make.centerX.equalToSuperview()
            make.height.width.equalTo(128)
        }
        
        view.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(statusImageV.snp.bottom)
            make.centerX.equalToSuperview()
            make.height.equalTo(25)
        }
        
        view.addSubview(nameLabel)
        nameLabel.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.centerX.equalToSuperview()
            make.left.equalTo(46)
            make.right.equalTo(-46)
        }
        
        view.addSubview(submitButton)
        submitButton.snp.makeConstraints { make in
            make.top.equalTo(nameLabel.snp.bottom).offset(42)
            make.centerX.equalToSuperview()
            make.width.equalTo(142)
            make.height.equalTo(42)
        }
        
        if isSuccessFlag {
            titleLabel.text = "报名成功"
            statusImageV.image = UIImage(named: "activity_apply_result_success")
            nameLabel.text = "已报名成功活动【" + activityName + "】，记得准时参加哦"
            submitButton.setTitle("查看行程单", for: .normal)
        } else {
            titleLabel.text = "报名失败"
            statusImageV.image = UIImage(named: "activity_apply_result_fail")
            nameLabel.text = "活动【" + activityName + "】，活动时间已结束，请您看看其他活动~"
            submitButton.setTitle("返回活动列表", for: .normal)

        }
    }
    
    @objc func clickSubmitBtn() {
        if isSuccessFlag {
            // 行程单详情
            gotoActivityTravelVC()
        } else {
            // 返回活动列表
            navigationController?.popToRootViewController(animated: true)
        }
    }
    
    func gotoActivityTravelVC() {
        if let nav = self.navigationController {
            let rrr = nav.viewControllers.contains { $0.isKind(of: YHActivityTravelViewController.self) }
            if rrr {
                
                var  targetVc: UIViewController?
                for(_, value) in nav.viewControllers.enumerated() {
                    if value.isKind(of: YHActivityTravelViewController.self) {
                        targetVc = value
                        break
                    }
                }
                
                if let vc = targetVc {
                    navigationController?.popToViewController(vc, animated: true)
                }
                return
            }
        }
        
        // 行程单详情
        let vc = YHActivityTravelViewController()
        vc.travelId = activityTravelId
        self.navigationController?.pushViewController(vc)
    }
}
