//
//  YHActivityDetailItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHActivityDetailItemView: UIView {

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    var dataModel: YHActivityDetailModel? {
        didSet {
            updateUI()
        }
    }
    
    private lazy var bottomLine: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.separatorColor
        return view
    }()
    
    lazy var nameLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_M(ofSize: 17)
        lable.text = "活动详情"
        lable.numberOfLines = 0
        return lable
    }()
    
    lazy var describeLable: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor70
        lable.textAlignment = .left
        lable.lineBreakMode = .byCharWrapping
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.text = " "
        lable.numberOfLines = 0
        lable.isHidden = true
        return lable
    }()
}

extension YHActivityDetailItemView {
    
    func updateUI() {
        guard let model = dataModel else {
            return
        }
        
        describeLable.text = model.introduce
        
        nameLabel.snp.remakeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(bottomLine.snp.bottom).offset(24)
        }
        var lastView: UIView = nameLabel
        
        if model.introduce.isEmpty {
            
        } else {
            describeLable.isHidden = false
            
            if model.posters.count > 0 {
                describeLable.snp.makeConstraints { make in
                    make.left.right.equalToSuperview()
                    make.top.equalTo(nameLabel.snp.bottom).offset(24)
                }
            } else {
                describeLable.snp.makeConstraints { make in
                    make.left.right.equalToSuperview()
                    make.top.equalTo(nameLabel.snp.bottom).offset(24)
                    
                    make.bottom.equalToSuperview()
                }
            }
            lastView = describeLable
            
        }
        
        if model.posters.count > 0 {
            for (index, value) in model.posters.enumerated() {
              print("Index: \(index), Value: \(value)")
                
                let imageV: UIImageView = UIImageView()
                imageV.contentMode = .scaleAspectFill
                imageV.clipsToBounds = true
                
                if let url = URL(string: value) {
                    imageV.kf.setImage(with: url, placeholder: UIImage(named: "global_default_image"))
                }
                
                addSubview(imageV)
                if model.posters.count - 1 == index {
                    if index == 0 {
                        imageV.snp.makeConstraints { make in
                            make.left.right.equalToSuperview()
                            make.top.equalTo(lastView.snp.bottom).offset(24)
                            make.height.equalTo(376)
                            
                            make.bottom.equalToSuperview()
                        }
                        
                    } else {
                        imageV.snp.makeConstraints { make in
                            make.left.right.equalToSuperview()
                            make.top.equalTo(lastView.snp.bottom).offset(20)
                            make.height.equalTo(376)
                            
                            make.bottom.equalToSuperview()
                        }
                    }
                    
                } else {
                    imageV.snp.makeConstraints { make in
                        make.left.right.equalToSuperview()
                        make.top.equalTo(lastView.snp.bottom).offset(20)
                        make.height.equalTo(376)
                    }
                }
                lastView = imageV
            }
        }
        
    }
    
    func setupUI() {
        addSubview(bottomLine)
        addSubview(nameLabel)
        addSubview(describeLable)
        
        bottomLine.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(1)
        }
        
        nameLabel.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(bottomLine.snp.bottom).offset(24)
            
            make.bottom.equalToSuperview()
        }
    }
}
