//
//  YHActivityListCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHActivityListCell: UITableViewCell {
    static let cellReuseIdentifier = "YHActivityListCell"
    
    var dataModel: YHActivityModel? {
        didSet {
            updateUI()
        }
    }
    
    var type: Int = 0 // 0-活动列表  1-我的报名活动
    
    var sessionIndex: Int = 0 {
        didSet {
            let tmp =  sessionIndex % 3
            let name = "activity_cell_bkg_" + String(tmp)
            bkgImgV.image = UIImage(named: name)
        }
    }
    
    lazy var bkgImgV: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "activity_cell_bkg_0")
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        return view
    }()
    
    lazy var vipImgV: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "activity_vip_icon")
        view.contentMode = .scaleAspectFill
        view.isHidden = true
        return view
    }()
    
    lazy var nameLabel: UILabel = {
        let nameLabel = UILabel()
        nameLabel.textColor = UIColor.mainTextColor
        nameLabel.textAlignment = .left
        nameLabel.font = UIFont.PFSC_M(ofSize: 18)
        nameLabel.text = "银河APP发布会"
        nameLabel.numberOfLines = 2
        return nameLabel
    }()
    
    lazy var activityImgV: UIImageView = {
        let view = UIImageView()
        view.contentMode = .scaleAspectFill
        view.image = UIImage(named: "global_default_image")
        view.clipsToBounds = true
        return view
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var dateLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor70
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.text = "08/08 周五 18:00-20:00"
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor70
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.text = "深圳深南大道本元大厦26A银河体验中心"
        return label
    }()
    
    lazy var statusLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.brandMainColor
        label.textAlignment = .right
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.text = "立即报名"
        return label
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
}

extension YHActivityListCell {
    func updateUI() {
        guard let model = dataModel else {
            return
        }
        
        if model.tag == 1 {
            vipImgV.isHidden = false
        } else {
            vipImgV.isHidden = true
        }
        
        if model.status.int == 5 {
            contentView.alpha = 0.4
        } else {
            contentView.alpha = 1.0
        }
        
        nameLabel.text = model.name
        
        if let url = URL(string: model.cover) {
            activityImgV.kf.setImage(with: url, placeholder: UIImage(named: "global_default_image"))
        } else {
            activityImgV.image = UIImage(named: "global_default_image")
        }
        
        //
        dateLabel.text = model.getDateString()
        
        //
        detailLabel.text = model.place
        
        if let status = Int(model.status) {
            if type == 0 {
                statusLabel.text = YHActivityStatus.init(rawValue: status)?.titleForList
                statusLabel.textColor = YHActivityStatus.init(rawValue: status)?.activityColor
            } else {
                statusLabel.text = YHActivityStatus.init(rawValue: status)?.titleForMyApplyList
                statusLabel.textColor = YHActivityStatus.init(rawValue: status)?.activityColorForMyApplyList
            }
        } else {
            statusLabel.text = ""
        }
    }
    
    func setupUI() {
        backgroundColor = .clear
        selectionStyle = .none
        
        contentView.addSubview(bkgImgV)
        contentView.addSubview(vipImgV)
        contentView.addSubview(nameLabel)
        contentView.addSubview(activityImgV)
        contentView.addSubview(lineView)
        contentView.addSubview(dateLabel)
        contentView.addSubview(detailLabel)
        contentView.addSubview(statusLabel)
        
        bkgImgV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        vipImgV.snp.makeConstraints { make in
            make.top.left.equalToSuperview()
            make.width.equalTo(44)
            make.height.equalTo(18)
        }
        
        activityImgV.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.top.equalTo(20)
            make.width.height.equalTo(72)
        }
        
        nameLabel.snp.makeConstraints { make in
            make.top.equalTo(28)
            make.left.equalTo(18)
            make.right.equalTo(activityImgV.snp.left).offset(-20)
            
        }
        
        lineView.snp.makeConstraints { make in
            make.top.equalTo(activityImgV.snp.bottom).offset(20)
            make.left.equalTo(nameLabel.snp.left)
            make.right.equalTo(activityImgV.snp.right)
            make.height.equalTo(1)
        }
        
        dateLabel.snp.makeConstraints { make in
            make.top.equalTo(lineView.snp.bottom).offset(14)
            make.left.equalTo(lineView.snp.left)
            make.right.equalTo(lineView.snp.right)
            make.height.equalTo(17)
        }
        
        statusLabel.snp.makeConstraints { make in
            make.top.equalTo(dateLabel.snp.bottom).offset(8)
            make.right.equalTo(dateLabel.snp.right)
            make.height.equalTo(17)
            make.width.equalTo(48)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.top.equalTo(statusLabel.snp.top)
            make.left.equalTo(dateLabel.snp.left)
            make.height.equalTo(17)
            make.right.equalTo(statusLabel.snp.left).offset(-16)
        }
    }
}
