//
//  YHActivityTitleItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHActivityTitleItemView: UIView {

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    var dataModel: YHActivityDetailModel? {
        didSet {
            updateUI()
        }
    }
    
    private lazy var nameTextView: UITextView  = {
        let lable0 = UITextView()
        lable0.textColor = UIColor.mainTextColor
        lable0.textAlignment = .left
        lable0.font = UIFont.PFSC_B(ofSize: 24)
        lable0.isScrollEnabled = false
        lable0.isEditable = false
        lable0.isSelectable = false
        lable0.backgroundColor = .clear
        
        lable0.textContainerInset = UIEdgeInsets.zero // 消除文本容器的内边距
        lable0.textContainer.lineFragmentPadding = 0
        return lable0
        
    }()
    
    lazy var timeStaticLable: UILabel = {
        let nameLabel = UILabel()
        nameLabel.textColor = UIColor.mainTextColor50
        nameLabel.textAlignment = .left
        nameLabel.font = UIFont.PFSC_R(ofSize: 14)
        nameLabel.text = "时间"
        return nameLabel
    }()
    
    lazy var timeLable: UILabel = {
        let nameLabel = UILabel()
        nameLabel.textColor = UIColor.mainTextColor
        nameLabel.textAlignment = .left
        nameLabel.font = UIFont.PFSC_R(ofSize: 14)
        nameLabel.text = "08-06 周五  09:30"
        return nameLabel
    }()
    
    lazy var addressStaticLable: UILabel = {
        let nameLabel = UILabel()
        nameLabel.textColor = UIColor.mainTextColor50
        nameLabel.textAlignment = .left
        nameLabel.font = UIFont.PFSC_R(ofSize: 14)
        nameLabel.text = "地址"
        return nameLabel
    }()
    
    lazy var addressLable: UILabel = {
        let nameLabel = UILabel()
        nameLabel.textColor = UIColor.mainTextColor
        nameLabel.textAlignment = .left
        nameLabel.font = UIFont.PFSC_R(ofSize: 14)
        nameLabel.text = "深圳市本元大厦26A银河集团体验中心"
        nameLabel.numberOfLines = 0
        return nameLabel
    }()
    
    lazy var navAddressLable: UILabel = {
        let nameLabel = UILabel()
        nameLabel.textColor = UIColor.mainTextColor50
        nameLabel.textAlignment = .left
        nameLabel.font = UIFont.PFSC_R(ofSize: 14)
        nameLabel.text = "距地铁10号线亮马站D口步行62"
        nameLabel.numberOfLines = 0
        return nameLabel
    }()
}

extension YHActivityTitleItemView {
    func updateUI() {
        guard let model = dataModel else {
            return
        }
        
        nameTextView.text = model.name
        if model.tag == 1 {
            nameTextView.attributed.text = """
            \(model.name + " ", .foreground(UIColor.mainTextColor), .font(UIFont.PFSC_B(ofSize: 22)))\(.image(UIImage(named: "activity_vip_icon2")!, .custom(.offset(CGPoint(x: 0, y: -9.0)), size: .init(width: 44, height: 34))))
            """
        } else {
            nameTextView.attributed.text = """
            \(model.name, .foreground(UIColor.mainTextColor), .font(UIFont.PFSC_B(ofSize: 22)))
            """
        }
        
        timeLable.text = model.getDateString(format: "yyyy-MM-dd")
        addressLable.text = model.place
        navAddressLable.text = model.guidance
    }
    
    func setupUI() {
        addSubview(nameTextView)
        addSubview(timeStaticLable)
        addSubview(timeLable)
        addSubview(addressStaticLable)
        addSubview(addressLable)
        addSubview(navAddressLable)
        
        nameTextView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
        }
        
        timeStaticLable.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.top.equalTo(nameTextView.snp.bottom).offset(24)
            make.height.equalTo(20)
            make.width.equalTo(28)
        }
        
        timeLable.snp.makeConstraints { make in
            make.left.equalTo(timeStaticLable.snp.right).offset(16)
            make.top.equalTo(timeStaticLable.snp.top)
            make.right.equalToSuperview()
        }
    
        addressStaticLable.snp.makeConstraints { make in
            make.left.equalTo(timeStaticLable.snp.left)
            make.top.equalTo(timeLable.snp.bottom).offset(13)
            make.height.equalTo(timeStaticLable.snp.height)
            make.width.equalTo(timeStaticLable.snp.width)
        }
        
        addressLable.snp.makeConstraints { make in
            make.left.equalTo(timeLable.snp.left)
            make.top.equalTo(addressStaticLable.snp.top)
            make.right.equalToSuperview()
        }
        
        navAddressLable.snp.makeConstraints { make in
            make.left.equalTo(addressLable.snp.left)
            make.top.equalTo(addressLable.snp.bottom).offset(8)
            make.right.equalToSuperview()
            
            make.bottom.equalToSuperview()
        }
        
//        nameTextView.attributed.text = """
//        \("", .foreground(UIColor.mainTextColor), .font(UIFont.PFSC_B(ofSize:24)))\(.image(UIImage(named: "activity_vip_icon2")!,.custom(.offset(CGPoint(x: 0, y: -7)), size: .init(width: 44, height: 34))))
//        """
    }
}
