//
//  YHPeopleCardModel.swift
//  galaxy
//
//  Created by edy on 2024/6/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHMatchUserInfo: SmartCodable {
    
    var id: String = ""
    var yhId: String = ""
    var username: String = ""
    var avatar: String = ""
    var position: String = ""
    var industry: String = ""
    var isSign: Bool = false
    var address: YHMatchUserAddress = YHMatchUserAddress()
    var signature: String = ""
    
    // 自定义属性
    // 是否发送了好友申请
    var isSendRequest = false
    
    required init() {
        
    }

    enum CodingKeys: String, CodingKey {
        case id
        case yhId = "yh_id"
        case isSign = "is_sign"
        case username, avatar, position, industry, address, signature
    }
}

// MARK: - Address
class YHMatchUserAddress: SmartCodable {
    var country: String = ""
    var province: String = ""
    var city: String = ""
    
    required init() {
        
    }
    
    func showCity() -> String {
        var cityStr = ""
        if self.country.contains("中国") {
            cityStr = self.city
            let specialArea = ["北京市", "上海市", "天津市", "重庆市", "香港", "澳门", "台湾"]
            for provinceName in specialArea {
                if self.province.contains(provinceName) {
                    cityStr = self.province
                    break
                }
            }
        } else { // 非中国 显示国家
            cityStr = self.country
        }
        return cityStr
    }
}

class YHAuthorizationModel: SmartCodable {
    
    var educationExperience: Int = 0
    var workExperience: Int = 0
    
    required init() {
        
    }

    enum CodingKeys: String, CodingKey {
        case educationExperience = "public_education_experience"
        case workExperience = "public_work_experience"
    }
}

enum YHNameCardInfoType: Int {
    case unknown = -1
    case avatar = 0
    case introduce = 1
    case education = 2
    case workExperience = 3
    case honor = 4
    case topics = 5
}

class YHUserNameCardInfo: SmartCodable {
    var id: String = ""
    var yhId: String = ""
    var isSigned: Bool = false
    var avatar: String = ""
    var username: String = ""
    var address: YHMatchUserAddress = YHMatchUserAddress()
    var zodiac: String = ""
    var signature: String = ""
    var bio: String = ""
    var college: String = ""
    var major: String = ""
    var background: String = ""
    var companyName: String = ""
    var position: String = ""
    var industry: String = ""
    var honor: String = ""
    var topics: [String] = []
    var draftTopics: [String] = []
    var authorization: YHAuthorizationModel = YHAuthorizationModel()
    
    // 自定义属性
    var type: YHNameCardInfoType = .unknown
    var isCurrentUser = false

    var isHiddenEducation: Bool {
        get {
            return self.authorization.educationExperience != 2
        }
    }
    var isHiddenWorkExperience: Bool {
        get {
            return self.authorization.workExperience != 2
        }
    }
    
    required init() {
        
    }
    
    func updateModel(_ model: YHUserNameCardInfo) {
        self.id = model.id
        self.yhId = model.yhId
        self.isSigned = model.isSigned
        self.avatar = model.avatar
        self.username = model.username
        self.address.province = model.address.province
        self.address.country = model.address.country
        self.address.city = model.address.city
        self.zodiac = model.zodiac
        self.signature = model.signature
        self.bio = model.bio
        self.college = model.college
        self.major = model.major
        self.background = model.background
        self.companyName = model.companyName
        self.position = model.position
        self.industry = model.industry
        self.honor = model.honor
        self.authorization.educationExperience = model.authorization.educationExperience
        self.authorization.workExperience = model.authorization.workExperience
        self.topics.removeAll()
        self.topics.append(contentsOf: model.topics)
    }

    enum CodingKeys: String, CodingKey {
        case yhId = "yh_id"
        case isSigned = "is_signed"
        case companyName = "company_name"
        case draftTopics = "draft_topics"
        case id, avatar, username, zodiac, signature, bio, college, major, background, position, industry, honor
        case topics
        case address
        case authorization
    }
}
