//
//  YHInterestTopicLayout.swift
//  galaxy
//
//  Created by edy on 2024/6/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInterestTopicLayout: UICollectionViewFlowLayout {
     
    var dataSource: [String] = []
    weak var layoutDelegate: UICollectionViewDelegateFlowLayout?
    var collectionViewWidth = KScreenWidth-16.0*4
    override func prepare() {
        super.prepare()
        self.minimumInteritemSpacing = 8.0
        self.minimumLineSpacing = 8.0
    }
    
    override func layoutAttributesForElements(in rect: CGRect) -> [UICollectionViewLayoutAttributes]? {
        let arrCell = super.layoutAttributesForElements(in: rect)
        if arrCell == nil { return nil }
        if arrCell!.count <= 1 { return arrCell }
        for i in 1 ..< arrCell!.count {
            // 当前 UICollectionViewLayoutAttributes
            let currentLayout = arrCell![i]
            // 上一个 UICollectionViewLayoutAttributes
            let prevLayout = arrCell![i - 1]
            if prevLayout.indexPath.section == currentLayout.indexPath.section {
                // 我们想设置的最大间距，可根据需要改
                let maximumSpacing = self.minimumInteritemSpacing
                // 前一个cell的最右边
                let originX = prevLayout.frame.maxX
                // 如果当 （上一个cell的最右边X + 我们想要的间距 + 当前cell的宽度 + 区边距） 依然在contentSize中 (小于屏幕宽度)，我们改变当前cell的原点位置
                // 判断 当前cell的 maxX 是否超出屏幕
                if (CGFloat(originX) + CGFloat(maximumSpacing) + currentLayout.frame.size.width) + self.sectionInset.right <= self.collectionViewWidth {
                    var frame = currentLayout.frame
                    frame.origin.x = CGFloat(originX) + CGFloat(maximumSpacing)
                    currentLayout.frame = frame
                    
                } else {
                    print("超出屏幕, 换一行")
                    var frame = currentLayout.frame
                    frame.origin.x = self.sectionInset.left
                    currentLayout.frame = frame
                }
            }
        }
        return arrCell
    }
    
    override var collectionViewContentSize: CGSize {
        get {
            let height = self.calculateHeight()
            return CGSize(width: self.collectionViewWidth, height: height)
        }
    }
    
    func calculateHeight() -> CGFloat {
        if self.dataSource.count <= 0 {
            return 0.0
        }
    
       guard let delegate = self.layoutDelegate else {
            return 0.0
        }
        let itemHeight = 24.0
        var currentX = 0.0
        var height = itemHeight
        
        for (index, _) in self.dataSource.enumerated() {
            if delegate.responds(to: #selector(UICollectionViewDelegateFlowLayout.collectionView(_:layout:sizeForItemAt:))) {
               let size = delegate.collectionView!(self.collectionView!, layout: self, sizeForItemAt: IndexPath(item: index, section: 0))
                if index == 0 {
                    currentX = size.width
                    height = itemHeight
                } else {
                    let targetX = currentX + self.minimumInteritemSpacing + size.width
                    if targetX <= self.collectionViewWidth {
                        currentX = targetX
                    } else {
                        currentX = size.width
                        height += self.minimumLineSpacing + itemHeight
                    }
                }
                printLog("calcaulte: \(height)")
            }
        }
        return height
    }
}
