//
//  YHMyNameCardAvatarInfoCell.swift
//  galaxy
//
//  Created by edy on 2024/6/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHMyNameCardAvatarInfoCell: UITableViewCell {
    typealias EditBlock = () -> Void
    var editBlock: EditBlock?
    static let cellReuseIdentifier = "YHMyNameCardAvatarInfoCell"
    
    let headWidth = 80.0
    var userModel: YHUserNameCardInfo = YHUserNameCardInfo() {
        didSet {
            
            self.professionalLabel.textColor = UIColor.mainTextColor
            self.detailLabel.textColor = UIColor.mainTextColor50
            self.editBtn.isHidden = !self.userModel.isCurrentUser

            if let url = URL(string: self.userModel.avatar) {
                self.headImgV.kf.setImage(with: url, placeholder: UIImage(named: "people_head_default"))
            } else {
                self.headImgV.image = UIImage(named: "people_head_default")
            }
            
            let cityStr = self.userModel.address.showCity()
            self.cityLabel.text = cityStr
            let cityWidth = self.getWith(font: self.cityLabel.font, height: 20, string: cityStr)
            self.cityLabel.frame = CGRect(x: 0, y: 0, width: cityWidth+8, height: 20)
            
            self.zodiacLabel.text = self.userModel.zodiac
            self.signImgV.isHidden = !self.userModel.isSigned

            var name: ASAttributedString = .init(string: self.userModel.username, .font(UIFont.PFSC_B(ofSize: 18)), .foreground(UIColor.mainTextColor))
            let cityTag: ASAttributedString = "  \(.view(self.cityLabel, .original(.center)))"
            let zodiacTag: ASAttributedString = "  \(.view(self.zodiacLabel, .original(.center)))"
            
            if !cityStr.isEmpty {
                name += cityTag
            }
            if !self.userModel.zodiac.isEmpty {
                name += zodiacTag
            }
            self.nameTextView.attributed.text = name
            
            var text1 = ""
            var text1Arr: [String] = []
            if !self.userModel.position.isEmpty {
                text1Arr.append(self.userModel.position)
            }
            if !self.userModel.industry.isEmpty {
                text1Arr.append(self.userModel.industry)
            }
            if text1Arr.count > 0 {
                text1 = text1Arr.joined(separator: " | ")
            }
                
            if text1.isEmpty {
                if self.userModel.isCurrentUser { // 当前用户默认文案
                    self.professionalLabel.textColor = UIColor.mainTextColor30
                    text1 = "填写职位 | 填写所属行业"
                }
            }
            self.professionalLabel.text = text1
            
            var text2 = ""
            if !self.userModel.signature.isEmpty {
                text2 = self.userModel.signature
            } else {
                if self.userModel.isCurrentUser { // 当前用户默认文案
                    self.detailLabel.textColor = UIColor.mainTextColor30
                    text2 = "填写个性签名，展现真我风采，彰显独特身份"
                }
            }
            self.detailLabel.text = text2
            var top2Margin =  8.0
            if text2.isEmpty {
                top2Margin = 0.0
            } else {
                top2Margin = text1.isEmpty ? 0.0 : 8.0
            }
            self.detailLabel.snp.updateConstraints { make in
                make.top.equalTo(self.professionalLabel.snp.bottom).offset(top2Margin)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var headImgV: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "people_head_default")
        view.layer.cornerRadius = headWidth/2.0
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        return view
    }()
    
    lazy var headBgImgV: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "people_user_head_bg")
        view.contentMode = .scaleToFill
        return view
    }()
    
    lazy var headBackImgV: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "people_user_head_back")
        return view
    }()
    
    lazy var signImgV: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "people_sign")
        return view
    }()
    
    lazy var cardView: UIView = {
        let view = UIView()
        view.layer.cornerRadius = 6.0
        view.backgroundColor = .white
        view.clipsToBounds = true
        return view
    }()
    
    lazy var bgImgV: UIImageView = {
        let bgImgView = UIImageView(image: UIImage(named: "people_add_friend_bg"))
        return bgImgView
    }()
    
    lazy var editBtn: UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "people_card_edit"), for: .normal)
        btn.addTarget(self, action: #selector(edit), for: .touchUpInside)
        btn.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20)
        return btn
    }()
    
    lazy var nameTextView: UITextView = {
        let textView = UITextView()
        textView.textColor = UIColor.mainTextColor
        textView.backgroundColor = .clear
        textView.font = UIFont.PFSC_B(ofSize: 18)
        textView.isScrollEnabled = false
        textView.isEditable = false
        textView.isSelectable = false
        return textView
    }()
    
    lazy var cityLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.brandMainColor
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize: 12)
        label.backgroundColor = .brandMainColor8
        label.layer.cornerRadius = 3.0
        label.clipsToBounds = true
        return label
    }()
    
    lazy var zodiacLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.brandMainColor
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize: 12)
        label.backgroundColor = .brandMainColor8
        label.layer.cornerRadius = 3.0
        label.clipsToBounds = true
        label.frame = CGRect(x: 0, y: 0, width: 46, height: 20)
        return label
    }()
    
    lazy var professionalLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.numberOfLines = 0
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor50
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.numberOfLines = 0
        return label
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        
        self.contentView.addSubview(self.cardView)
        self.contentView.addSubview(self.headImgV)
        self.contentView.addSubview(self.headBackImgV)
        self.contentView.addSubview(self.headBgImgV)
        self.contentView.addSubview(self.signImgV)
        
        cardView.addSubview(self.bgImgV)
        cardView.addSubview(self.nameTextView)
        cardView.addSubview(self.professionalLabel)
        cardView.addSubview(self.detailLabel)
        cardView.addSubview(self.editBtn)
        
        self.cardView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(headWidth/2.0)
        }
        
        self.bgImgV.snp.makeConstraints { make in
            make.left.right.right.equalToSuperview()
            make.height.equalTo(160)
        }
        
        self.editBtn.snp.makeConstraints { make in
            make.width.height.equalTo(20)
            make.right.equalTo(-16)
            make.top.equalTo(16)
        }
        
        self.headBackImgV.snp.makeConstraints { make in
            make.width.height.equalTo(headWidth+4)
            make.center.equalTo(self.headImgV)
        }
        
        self.headBgImgV.snp.makeConstraints { make in
            make.width.height.equalTo(headWidth)
            make.center.equalTo(self.headImgV)
        }
        self.headImgV.snp.makeConstraints { make in
            make.width.height.equalTo(headWidth)
            make.left.equalTo(10)
            make.top.equalTo(0)
        }
        
        self.signImgV.snp.makeConstraints { make in
            make.width.equalTo(49)
            make.height.equalTo(17)
            make.bottom.equalTo(self.headBgImgV)
            make.centerX.equalTo(self.headImgV)
        }
        
        self.nameTextView.snp.makeConstraints { make in
            make.left.equalTo(10)
            make.right.equalTo(-16)
            make.top.equalTo(headWidth/2.0)
        }
        
        self.professionalLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(self.nameTextView.snp.bottom).offset(0)
        }
        
        self.detailLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(self.professionalLabel.snp.bottom).offset(8)
            make.bottom.equalTo(-16)
        }
        
        self.professionalLabel.setContentCompressionResistancePriority(.required, for: .vertical)
        self.professionalLabel.setContentHuggingPriority(.required, for: .vertical)
        
        self.detailLabel.setContentCompressionResistancePriority(.required, for: .vertical)
        self.detailLabel.setContentHuggingPriority(.required, for: .vertical)
    }
    
    func getWith(font: UIFont, height: CGFloat, string: String) -> CGFloat {
        let size = CGSize.init(width: CGFloat(MAXFLOAT), height: height)
        let dic = [NSAttributedString.Key.font: font] // swift 4.2
        let strSize = string.boundingRect(with: size, options: [.usesLineFragmentOrigin], attributes: dic, context: nil).size
        return CGSize(width: ceil(strSize.width), height: strSize.height).width
    }
    
    @objc func edit() {
        if let block = editBlock {
            block()
        }
    }
}
