//
//  YHHomeIdentityViewController.swift
//  galaxy
//
//  Created by edy on 2024/7/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHHomeIdentityViewController: YHBaseViewController {
    
    var subTabArr: [YHHomeLifeCategoryModel] = []
    
    lazy var viewModel: YHHomePageViewModel = {
        let vm = YHHomePageViewModel()
        return vm
    }()
    
    lazy var subTabBar: YHIdentityTabBar = {
        let bar = YHIdentityTabBar.tabBarForItems([])
        bar.selectBlock = {
            [weak self] index, _ in
            guard let self = self else { return }
            self.scrollView.setContentOffset(CGPoint(x: KScreenWidth * Double(index), y: 0), animated: false)
            if 0 <= index, index < self.children.count {
                let vc = self.children[index]
                if vc.isKind(of: YHHomeIdentityListVC.self) {
                    if let vc = vc as? YHHomeIdentityListVC {
                        vc.isShowBottomView = false
                    }
                    self.hideBottomOnTabbar()
                }
            }
        }
        return bar
    }()
    
    lazy var scrollView: UIScrollView = {
        let view = UIScrollView()
        view.isScrollEnabled = false
        return view
    }()
    
    lazy var noDataView: YHEmptyDataView = {
        let view = YHEmptyDataView.createView("暂无内容", kEmptyCommonBgName)
        view.backgroundColor = .white
        view.topMargin = 150
        view.isHidden = true
        return view
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        createUI()
        loadData()
    }
    
    func createUI() {
        gk_navigationBar.isHidden = true
        self.view.backgroundColor = .white

        self.view.addSubview(self.scrollView)
        self.view.addSubview(self.subTabBar)
        self.view.addSubview(self.noDataView)
        
        self.subTabBar.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.height.equalTo(44)
        }
        self.scrollView.snp.makeConstraints { make in
            make.top.equalTo(self.subTabBar.snp.bottom)
            make.left.right.bottom.equalToSuperview()
        }
        
        self.noDataView.snp.makeConstraints { make in
            make.left.right.top.bottom.equalToSuperview()
        }
        
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        hideBottomOnTabbar()
    }
    
    func hideBottomOnTabbar() {
        // 隐藏
        var model = TabBarShareModel()
        model.showFlag = false
        NotificationCenter.default.post(name: YhConstant.YhNotification.changeShareViewStatusOnTabBarNotifiction, object: model)
    }
}

extension YHHomeIdentityViewController: JXSegmentedListContainerViewListDelegate {
    func listView() -> UIView {
        return view
    }
}

extension YHHomeIdentityViewController {
    
    func loadData() {
        let params: [String: Any] = ["pid": 2]
        self.viewModel.getGoodsCategory(params: params) {
            [weak self] success, _ in
            
            self?.scrollView.es.stopPullToRefresh()
            
            guard let self = self else { return }
            
            if !success {
                self.view.bringSubviewToFront(self.noDataView)
                self.noDataView.isHidden = false
            }
            
            subTabArr.removeAll()
            for item in self.viewModel.categoryArr {
                if let item = item {
                    subTabArr.append(item)
                }
            }
            self.subTabBar.updateItems(subTabArr)
            
            self.scrollView.removeSubviews()
            for (index, item) in subTabArr.enumerated() {
                let vc = YHHomeIdentityListVC()
                vc.detailId = item.id
                vc.view.frame = CGRect(x: KScreenWidth * Double(index), y: 0, width: KScreenWidth, height: self.scrollView.height)
                vc.loadData()
                self.addChild(vc)
                self.scrollView.addSubview(vc.view)
            }
            self.scrollView.contentSize = CGSize(width: KScreenWidth * Double(self.subTabArr.count), height: self.scrollView.height)
        }
    }
}
