//
//  YHGalaxyManagerTipsItemView.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGalaxyManagerTipsItemView: UIView {
    
    static let viewH = 52.0
    private let dotWidth = 6.0
    var buttonClickEvent: (() -> Void)?
    
    private var isMessageRead: Bool = true {
        didSet {
            dotView.isHidden = isMessageRead
        }
    }

    // 银河管家
    private lazy var lableGalaxyMgr: UILabel = {
        let lable: UILabel = UILabel()
        lable.text = "银河管家"
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.textColor = UIColor.mainTextColor
        return lable
    }()
    
    // 分割线
    private lazy var segmentationView: UIView = {
        let view: UIView = UIView()
        view.backgroundColor = UIColor.mainTextColor18
        return view
    }()
    
    // 一对一专属服务
    private lazy var lableMessage: UILabel = {
        let lable: UILabel = UILabel()
        lable.text = "一对一专属服务"
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.textColor = UIColor.mainTextColor70
        lable.lineBreakMode = .byTruncatingTail
        return lable
    }()
    
    private lazy var dotView: UIView = {
        let view = UIView()
        view.backgroundColor = .failColor
        view.layer.cornerRadius = self.dotWidth/2.0
        view.isHidden = true
        return view
    }()
        
    // 右箭头
    private lazy var rightIconImageV: UIImageView = {
        let imgV: UIImageView = UIImageView()
        imgV.contentMode = .scaleAspectFill
        imgV.image = UIImage(named: "home_order_tips_right_arrow")
        return imgV
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

extension YHGalaxyManagerTipsItemView {
    
    func updateMessageState(didReadMessage: Bool) {
        self.isMessageRead = didReadMessage
    }
    
    func updateManagerTipsItemView(message: String?, didReadMessage: Bool = true) {
        lableMessage.text = message
        updateMessageState(didReadMessage: didReadMessage)
    }
}

extension YHGalaxyManagerTipsItemView {
    
    @objc private func tapButton(gestureRecognizer: UITapGestureRecognizer) {
        buttonClickEvent?()
    }
    
    private func setupUI() {
        backgroundColor = UIColor(hex: 0xffffff, alpha: 0.65)
        layer.borderWidth = 0.5
        layer.borderColor = UIColor.white.cgColor
        
        addSubview(lableGalaxyMgr)
        addSubview(segmentationView)
        addSubview(rightIconImageV)
        addSubview(dotView)
        addSubview(lableMessage)
        lableGalaxyMgr.setContentCompressionResistancePriority(.required, for: .horizontal)
        lableGalaxyMgr.setContentCompressionResistancePriority(.required, for: .horizontal)
        rightIconImageV.setContentCompressionResistancePriority(.required, for: .horizontal)
        dotView.setContentCompressionResistancePriority(.required, for: .horizontal)
        lableMessage.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        lableGalaxyMgr.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(12)
            make.height.equalTo(18)
        }
        
        segmentationView.snp.makeConstraints { make in
            make.left.equalTo(lableGalaxyMgr.snp.right).offset(8)
            make.height.equalTo(10)
            make.width.equalTo(1).priority(.high)
            make.centerY.equalToSuperview()
        }
        
        rightIconImageV.snp.makeConstraints { make in
            make.right.equalTo(-12)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(12).priority(.high)
        }
        
        dotView.snp.makeConstraints { make in
            make.width.height.equalTo(dotWidth).priority(.high)
            make.right.equalTo(rightIconImageV.snp.left).offset(-12)
            make.centerY.equalToSuperview()
        }
        
        lableMessage.snp.makeConstraints { make in
            make.left.equalTo(segmentationView.snp.right).offset(8).priority(.high)
            make.height.equalTo(18)
            make.centerY.equalToSuperview()
            make.right.lessThanOrEqualTo(dotView.snp.left).offset(-12)
        }
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(tapButton(gestureRecognizer:)))
        addGestureRecognizer(tap)
    }
}
