//
//  YHTalentProgramEvaluationView.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/6.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHTalentProgramEvaluationView: UIView {
    private var url: String = ""
    static let viewH = 82.0

    private lazy var bgImageView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "talent_program_evaluation"))
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupViews()
        let tap: UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(tapButton(gestureRecognizer:)))
        addGestureRecognizer(tap)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func updateUrl(_ url: String) {
        self.url = url
    }
    
    private func setupViews() {
        addSubview(bgImageView)
        let ratio: CGFloat = 82.0 / 335.0
        bgImageView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(bgImageView.snp.width).multipliedBy(ratio)
        }
        
    }
    
    @objc func tapButton(gestureRecognizer: UITapGestureRecognizer) {
        guard url.count > 0 else {
            return
        }
        // 跳转测评页
        let vc = YHH5WebViewVC()
        var retUrl = ""
        if YHLoginManager.shared.isLogin() {
            let token = YHLoginManager.shared.h5Token
            if url.contains("?") {
                retUrl = url + "&param=" + token
            } else {
                retUrl = url + "?param=" + token
            }
        } else {
            retUrl = url
        }
        if !retUrl.contains("navigationH=") {
            if retUrl.contains("?") {
                retUrl += "&navigationH=\(k_Height_NavigationtBarAndStatuBar)"
            } else {
                retUrl += "?navigationH=\(k_Height_NavigationtBarAndStatuBar)"
            }
        }
        vc.url = retUrl
        parentViewController?.navigationController?.pushViewController(vc)
    }
}
