//
//  YHUserLevelAlertView.swift
//  galaxy
//
//  Created by EDY on 2025/2/26.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHUserLevelAlertView: UIView {
    typealias Block = (Int) -> Void
    var block: Block?
    var centerView: UIView!
    var topImageView: UIImageView!
    var bgImageView: UIImageView!
    var closeButton: UIButton!
    var shareButton: UIButton!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
//        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
//        tap.delegate = self
//        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x000000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .clear
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.right.top.bottom.equalToSuperview()
        }
        
        topImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "home_user_level_bg")
            return imageView
        }()
        centerView.addSubview(topImageView)
        topImageView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.height.equalTo(397)
            make.width.equalTo(299)
        }
        
        closeButton = {
            let button = UIButton(type: .custom)
            button.setImage(UIImage(named: "home_user_level_close"), for: .normal)
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(closeButton)
        closeButton.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.height.equalTo(24)
            make.width.equalTo(24)
            make.top.equalTo(topImageView.snp.bottom).offset(18)
        }
        
        shareButton = {
            let button = UIButton(type: .custom)
            button.addTarget(self, action: #selector(share), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(shareButton)
        shareButton.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.height.equalTo(48)
            make.width.equalTo(247)
            make.bottom.equalTo(topImageView.snp.bottom).offset(-28)
        }
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        dismiss()
    }
    
    @objc func dismiss() {
        removeFromSuperview()
        block?(0)
    }
    
    @objc func share() {
        removeFromSuperview()
        block?(1)
    }
}

extension YHUserLevelAlertView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
