//
//  YHHomeWebViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/4/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHomeWebViewModel: YHBaseViewModel {
    // 数据源
    var mainModel: YHWebModel?
}

extension YHHomeWebViewModel {
    // 请求web详情
    func getWebDetail(_ id: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Common.webInfo
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            guard let dic = json.data?.peel as?  [String: Any], let resultModel = YHWebModel.deserialize(from: dic) else {
                callBackBlock(false, nil)
                return
            }
            self.mainModel = resultModel
            callBackBlock(true, nil)
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // type:0取消 1收藏
    func getStar(_ id: Int, _ type: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["operate_type": type,
                                      "article_id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Common.star
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            guard let self = self else { return }
            // 1. json字符串 转 对象
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            
            callBackBlock(false, err)
        }
    }
    
    // type:0取消 1收藏
    func getLike(_ id: Int, _ type: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["operate_type": type,
                                      "article_id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Common.like
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            guard let self = self else { return }
            // 1. json字符串 转 对象
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            
            callBackBlock(false, err)
        }
    }
}
