//
//  YHSelectMenuView.swift
//  galaxy
//
//  Created by EDY on 2024/11/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSelectMenuView: UIView {
    var backDate: ((Int) -> Void)?
    var centerView: UIView!
    var tableView: UITableView!
    var dataSource: [String] = [] {
        didSet {
            self.tableView.reloadData()
        }
    }
    var selectItem: Int = 10000
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(400)
        }
        
        tableView = {
            let tableView = UITableView(frame: .zero, style: .grouped)
            tableView.contentInsetAdjustmentBehavior = .never
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.register(cellWithClass: YHSelectMenuCell.self)
            return tableView
        }()
        centerView.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.height.equalTo(376)
            make.left.right.equalToSuperview()
        }
        
//        centerView.layoutIfNeeded()
//        let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue | UIRectCorner.topRight.rawValue)
//        let path = UIBezierPath(roundedRect:bounds,byRoundingCorners: corner,cornerRadii:CGSizeMake(kCornerRadius6, kCornerRadius6))
//        let layer = CAShapeLayer()
//        layer.frame = centerView.bounds
//        layer.path = path.cgPath
//        centerView.layer.mask = layer
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        dismiss()
    }
    
    func show(top: CGFloat, selectItem: Int = 1000, dataSource: [String], callBack: @escaping ((Int) -> Void)) {
        self.frame = CGRect(x: 0, y: top, width: KScreenWidth, height: KScreenHeight - top)
        self.selectItem = selectItem
        self.dataSource = dataSource
        self.backDate = callBack
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(self)
    }
    
    @objc func dismiss() {
        if let block = backDate {
            block(selectItem)
        }
        removeFromSuperview()
    }
}

extension YHSelectMenuView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}

extension YHSelectMenuView: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return dataSource.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHSelectMenuCell.self)
        cell.updateModel(dataSource[indexPath.row])
        if selectItem == indexPath.row {
            cell.nameLabel.textColor = UIColor.brandMainColor
        } else {
            cell.nameLabel.textColor = UIColor.mainTextColor
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 40
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 7))
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }

    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if let block = self.backDate {
            block(indexPath.row)
        }
        removeFromSuperview()
    }
}

class YHSelectMenuCell: UITableViewCell {
    var nameLabel: UILabel!
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func updateModel(_ model: String) {
        nameLabel.text = model
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white
        
        nameLabel = UILabel()
        nameLabel.textColor = UIColor.mainTextColor
        nameLabel.textAlignment = .left
        nameLabel.numberOfLines = 0
        nameLabel.font = UIFont.PFSC_R(ofSize: 14)
        contentView.addSubview(nameLabel)
        
        nameLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.right.bottom.equalToSuperview()
        }
    }
}
