//
//  YHOrderSearchViewController.swift
//  galaxy
//
//  Created by EDY on 2024/6/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHOrderSearchViewController: YHBaseViewController {
    var tableView: UITableView!
    var searchBar: YHSearchInfoBar!
    var emptyDataTipsView: YHEmptyDataView!
    var items: [YHContactItemModel] = []
    var mobile: String = ""
    var viewModel: YHServiceOrderSearchViewModel = YHServiceOrderSearchViewModel()

    override func viewDidLoad() {
        super.viewDidLoad()
        setView()
    }
    
    func setView() {
        gk_navTitle = "订单搜索"
        gk_navBackgroundColor = UIColor.white
        gk_navBarAlpha = 1
        
        let searchView = UIView()
        searchView.backgroundColor = .white
        view.addSubview(searchView)
        searchView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.equalToSuperview()
            make.height.equalTo(52)
        }
        
        searchBar = {
            let bar = YHSearchInfoBar()
            bar.placeHolder = "请输入签约合同号"
            bar.setSearchButtonEnable(false)
            bar.searchBlock = {
                [weak self] text in
                guard let self = self else { return }
                self.viewModel.getSearchList(text ?? "", callBackBlock: {[weak self] _, _ in
                    guard let self = self else { return }
                    self.items = self.viewModel.arrContactList
                    self.emptyDataTipsView.isHidden = (items.count > 0)
                    self.tableView.reloadData()
                })
            }
            bar.textChange = {
                [weak self] text in
                guard let self = self else { return }
                if isEmptyString(text) {
                    bar.setSearchButtonEnable(false)
                } else {
                    bar.setSearchButtonEnable(true)
                }
            }
            return bar
        }()
        view.addSubview(searchBar)
        searchBar.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 8)
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.height.equalTo(36)
        }
        
        emptyDataTipsView = {
            let view = YHEmptyDataView.createView("没有搜索到相关订单", kEmptySearchBgName)
            view.topMargin = 204
            view.isHidden = true
            return view
        }()
        
        tableView = {
            let tableView = UITableView(frame: .zero, style: .grouped)
            if #available(iOS 11.0, *) {
                tableView.contentInsetAdjustmentBehavior = .never
            }
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.backgroundView = emptyDataTipsView
            tableView.register(cellWithClass: YHOrderDetailTableViewCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 52)
            make.left.right.bottom.equalTo(view)
        }
        
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        if items.count == 0 {
            searchBar.textField.becomeFirstResponder()
        }
    }
}

extension YHOrderSearchViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return items.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHOrderDetailTableViewCell.self)
        cell.dataSource = items[indexPath.row]
        cell.cellBlock = {[weak self] model in
            guard let self = self else { return }
            if self.mobile == model.mobile {
                if let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") as? Int {
                    if orderID == model.id {
                        self.navigationController?.popToRootViewController(animated: true)
                    } else {
                        let vc = YHServiceCenterViewController()
                        vc.model = model
                        self.navigationController?.pushViewController(vc)
                    }
                } else {
                    self.navigationController?.popToRootViewController(animated: true)
                }
            } else {
                let vc = YHServiceCenterViewController()
                vc.model = model
                self.navigationController?.pushViewController(vc)
            }
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 295
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 7))
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 7
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
}
