//
//  YHServiceOrderInIncubationSectionView.swift
//  galaxy
//
//  Created by EDY on 2024/11/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHServiceOrderInIncubationSectionView: UIView {
    typealias Block = (Int) -> Void
    var block: Block?
    var oneButton: UIButton!
    
    public override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    private func initView() {
        oneButton = {
            let btn = UIButton(type: .custom)
            btn.setBackgroundImage(UIImage(named: "service_center_In_section"), for: .normal)
            btn.addTarget(self, action: #selector(oneBtnClick), for: .touchUpInside)
            return btn
        }()
        addSubview(oneButton)
        oneButton.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(42.fix)
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func oneBtnClick() {
        if let block = block {
            block(1)
        }
    }
}
