//
//  YHServiceStepThreeSectionView.swift
//  galaxy
//
//  Created by EDY on 2024/9/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHServiceStepThreeSectionView: UIView {
    typealias Block = (Int) -> Void
    var block: Block?
    var oneButton: UIButton!
    var twoButton: UIButton!
    var threeButton: UIButton!
    var fourButton: UIButton!
    
    public override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    private func initView() {
        let space = (KScreenWidth - 77 * 4 - 32)/3.0
        oneButton = {
            let btn = UIButton(type: .custom)
            btn.setBackgroundImage(UIImage(named: "service_center_step_section_one"), for: .normal)
            btn.addTarget(self, action: #selector(oneBtnClick), for: .touchUpInside)
            return btn
        }()
        addSubview(oneButton)
        oneButton.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(16)
            make.height.equalTo(80)
            make.width.equalTo(77)
        }
        
        twoButton = {
            let btn = UIButton(type: .custom)
            btn.setBackgroundImage(UIImage(named: "service_center_step_section_two"), for: .normal)
            btn.addTarget(self, action: #selector(twoBtnClick), for: .touchUpInside)
            return btn
        }()
        addSubview(twoButton)
        twoButton.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(oneButton.snp.right).offset(space)
            make.height.equalTo(80)
            make.width.equalTo(77)
        }
        
        fourButton = {
            let btn = UIButton(type: .custom)
            btn.setBackgroundImage(UIImage(named: "service_center_step_section_four"), for: .normal)
            btn.addTarget(self, action: #selector(fourBtnClick), for: .touchUpInside)
            return btn
        }()
        addSubview(fourButton)
        fourButton.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(80)
            make.width.equalTo(77)
        }
        
        threeButton = {
            let btn = UIButton(type: .custom)
            btn.setBackgroundImage(UIImage(named: "service_center_step_section_three"), for: .normal)
            btn.addTarget(self, action: #selector(threeBtnClick), for: .touchUpInside)
            return btn
        }()
        addSubview(threeButton)
        threeButton.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.right.equalTo(fourButton.snp.left).offset(-space)
            make.height.equalTo(80)
            make.width.equalTo(77)
        }
        
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func oneBtnClick() {
        if let block = block {
            block(1)
        }
    }
    
    @objc func twoBtnClick() {
        if let block = block {
            block(2)
        }
    }
    
    @objc func threeBtnClick() {
        if let block = block {
            block(3)
        }
    }
    
    @objc func fourBtnClick() {
        if let block = block {
            block(4)
        }
    }
}
