//
//  YHServiceOrderSearchViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/6/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHServiceOrderSearchViewModel: YHBaseViewModel {
    var arrContactList: [YHContactItemModel] = []

    // 请求白名单
    func getWhitelist(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Order.bywhitelist
        _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String: Any], let data = dic["Data"] as? [Any], let result = [YHServiceSearchModel].deserialize(from: data) else {
                    callBackBlock(false, nil)
                    return
                }
                if result.count != 0, let model = result.first, model.dictionary_code.count != 0 {
                    callBackBlock(true, nil)
                } else {
                    callBackBlock(false, nil)
                }
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.count > 0 ? json.msg : "数据错误")
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // 请求合同项
    func getSearchList(_ order: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["order_sn": order]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Order.byorderid
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [Any], let resultModel = [YHContactItemModel].deserialize(from: dic) else {
                    self.arrContactList = []
                    callBackBlock(false, nil)
                    return
                }
                let lastArray = resultModel.compactMap { $0 }
                self.arrContactList = lastArray
                callBackBlock(true, nil)
            } else {
                self.arrContactList = []
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.count > 0 ? json.msg : "数据错误")
                callBackBlock(false, error)
            }
        } failBlock: { err in
            self.arrContactList = []
            callBackBlock(false, err)
        }
    }
    
    func getAssistList(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Order.assist
        _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let data = dic["orders"] as? [Any], let resultModel = [YHContactItemModel].deserialize(from: data) else {
                    self.arrContactList = []
                    callBackBlock(false, nil)
                    return
                }
                let lastArray = resultModel.compactMap { $0 }
                self.arrContactList = lastArray
                callBackBlock(true, nil)
            } else {
                self.arrContactList = []
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.count > 0 ? json.msg : "数据错误")
                callBackBlock(false, error)
            }
        } failBlock: { err in
            self.arrContactList = []
            callBackBlock(false, err)
        }
    }
    
}
