//
//  YHAdoptedChinaTravelViewController.swift
//  galaxy
//
//  Created by EDY on 2024/8/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdoptedChinaTravelViewController: YHBaseViewController {
    var tableView: UITableView!
    var nextButton: UIButton!
    var clickIndex = -1
    var data: [YHItemModel] = []
    var viewModel = YHYHAdopterTravelViewModel()
    var model: YHAdopterDependentDataDocModel = YHAdopterDependentDataDocModel()
    var urls: [String] = [""]
    
    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navTitle = "上传中国旅行证"
        gk_navBackgroundColor = .white
        gk_navBarAlpha = 1
        urls = model.url
        if urls.count == 0 {
            urls = [""]
        }
        setView()
        getData()
    }
    
    func getData() {
        viewModel.mainModel = model
        tableView.reloadData()
    }
    
    func setView() {
        view.backgroundColor = .white
        tableView = {
            let tableView = UITableView(frame: .zero, style: .plain)
            tableView.contentInsetAdjustmentBehavior = .never
            tableView.backgroundColor = .white
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.register(cellWithClass: YHAdopterExampleTableViewCell.self)
            tableView.register(cellWithClass: YHAdopterResidentTableViewCell.self)
            tableView.register(cellWithClass: YHAdopterCardExplainTableViewCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 8)
            make.bottom.left.right.equalTo(view)
        }
    
        nextButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("确认上传", for: .normal)
            button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(nextStep), for: .touchUpInside)
            return button
        }()
        view.addSubview(nextButton)
        nextButton.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(-8 - k_Height_safeAreaInsetsBottom())
            make.height.equalTo(48)
        }
        if model.status == 1 || model.status == 3 {
            nextButton.isHidden = true
        } else {
            tableView.snp.remakeConstraints { make in
                make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 8)
                make.left.right.equalTo(view)
                make.bottom.equalTo(-56 - k_Height_safeAreaInsetsBottom())
            }
        }
    }
    
    @objc func nextStep() {
        for item in urls {
            if item.count == 0 {
                self.getData()
                YHHUD.flash(message: "请上传文件")
                return
            }
        }
        viewModel.postdependentsUpload(urls: urls) {[weak self] _, _ in
            guard let self = self else { return }
            self.navigationController?.popViewController(animated: true)
        }
    }
    
}

extension YHAdoptedChinaTravelViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 2
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if indexPath.row == 0 {
            let cell = tableView.dequeueReusableCell(withClass: YHAdopterCardExplainTableViewCell.self)
            cell.titleLabel.text = "中国旅行证"
            cell.docDataSource = model
            cell.titleLabel.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(16)
                make.height.equalTo(24)
            }
            return cell
        }
        if indexPath.row == 1 {
            let cell = tableView.dequeueReusableCell(withClass: YHAdopterResidentTableViewCell.self)
            cell.firstImageName = "service_adopter_card_china_travel_front"
            cell.firstLabelName = "中国旅行证"
            cell.urls = urls
            cell.state = model.status
            cell.urlBlock = { [weak self] url, index in
                guard let self = self else { return }
                self.urls[index] = url
            }
            cell.deleteBlock = { [weak self] url, index in
                guard let self = self else { return }
                self.urls[index] = url
            }
            return cell
        }
 
        return UITableViewCell()
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if indexPath.row == 0 {
            if model.reject_reason.count != 0 && model.status == 2 {
                return 73
            }
            return 40
        }
        if indexPath.row == 1 {
            return 173
        }
        return 0
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
       
    }
    
}
