//
//  YHAdopterIncomeTitleTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterIncomeTitleTableViewCell: UITableViewCell {
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var alertLabel: UILabel!
    var failLabel: UILabel!
    var failImageView: UIImageView!
    var dataSource: YHAdopterDepositModel? {
        didSet {
            updateContent()
        }
    }
    
    var docDataSource: YHAdopterDependentDataDocModel? {
        didSet {
            updateDocContent()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear

        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = "存款证明"
            return label
        }()
        contentView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.text = "已完成"
            label.font = UIFont.PFSC_M(ofSize: 10)
            label.textColor = UIColor(hex: 0x3cc694)
            label.backgroundColor = UIColor(hex: 0xf0fbf7)
            label.textAlignment = .center
            // 带上传
//            label.textColor = UIColor.brandMainColor
//            label.backgroundColor = UIColor(hex: 0xf0f4fb)
            // 审核中
//            label.textColor = UIColor(hex: 0xff8000)
//            label.backgroundColor = UIColor(hex: 0xfff5eb)
            // 已驳回
//            label.textColor = UIColor(hex: 0xf81d22)
//            label.backgroundColor = UIColor(hex: 0xfff2f2)
            return label
        }()
        contentView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(titleLabel.snp.right).offset(4)
            make.width.equalTo(38)
            make.height.equalTo(16)
            make.centerY.equalTo(titleLabel.snp.centerY)
        }
        
        alertLabel = {
            let label = UILabel()
            label.text = "存款证明需主申名下，申请前近3个月内开具有效，总存款金额为所有家庭成员(包括额外新增受养人)的个数乘以12万，如一家三口则需主申直接开具36万"
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textColor = UIColor.mainTextColor50
            label.numberOfLines = 0
            return label
        }()
        contentView.addSubview(alertLabel)
        alertLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(46)
            make.right.equalTo(-18)
        }
        
        failLabel = {
            let label = UILabel()
            label.text = "驳回原因：存款证明钱不够"
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor(hex: 0xf81d22)
            return label
        }()
        contentView.addSubview(failLabel)
        failLabel.snp.makeConstraints { make in
            make.left.equalTo(36)
            make.bottom.equalTo(0)
            make.height.equalTo(17)
            make.right.equalToSuperview()
        }
        
        failImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "service_adopter_income_fail_alert")
            return view
        }()
        contentView.addSubview(failImageView)
        failImageView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.width.height.equalTo(12)
            make.centerY.equalTo(failLabel.snp.centerY)
        }
        
    }

    func updateContent() {
        guard let data = dataSource else { return }
        if data.status == 4 {
            subTitleLabel.textColor = UIColor.brandMainColor
            subTitleLabel.backgroundColor = UIColor(hex: 0xf0f4fb)
            failImageView.isHidden = true
            failLabel.isHidden = true
            subTitleLabel.text = "待上传"
        }
        if data.status == 0 {
            subTitleLabel.textColor = UIColor(hex: 0xff8000)
            subTitleLabel.backgroundColor = UIColor(hex: 0xfff5eb)
            failImageView.isHidden = true
            failLabel.isHidden = true
            subTitleLabel.text = "审核中"
        }
        if data.status == 1 {
            subTitleLabel.textColor = UIColor(hex: 0x3cc694)
            subTitleLabel.backgroundColor = UIColor(hex: 0xf0fbf7)
            failImageView.isHidden = true
            failLabel.isHidden = true
            subTitleLabel.text = "已完成"
        }
        if data.status == 2 {
            subTitleLabel.textColor = UIColor(hex: 0xf81d22)
            subTitleLabel.backgroundColor = UIColor(hex: 0xfff2f2)
            failImageView.isHidden = false
            failLabel.isHidden = false
            subTitleLabel.text = "已驳回"
        }
        failLabel.text = data.remark
    }
    
    func updateDocContent() {
        guard let data = docDataSource else { return }
        if data.status == 0 {
            subTitleLabel.textColor = UIColor.brandMainColor
            subTitleLabel.backgroundColor = UIColor(hex: 0xf0f4fb)
            failImageView.isHidden = true
            failLabel.isHidden = true
            subTitleLabel.text = "待上传"
        }
        if data.status == 1 {
            subTitleLabel.textColor = UIColor(hex: 0xff8000)
            subTitleLabel.backgroundColor = UIColor(hex: 0xfff5eb)
            failImageView.isHidden = true
            failLabel.isHidden = true
            subTitleLabel.text = "审核中"
        }
        if data.status == 3 {
            subTitleLabel.textColor = UIColor(hex: 0x3cc694)
            subTitleLabel.backgroundColor = UIColor(hex: 0xf0fbf7)
            failImageView.isHidden = true
            failLabel.isHidden = true
            subTitleLabel.text = "已完成"
        }
        if data.status == 2 {
            subTitleLabel.textColor = UIColor(hex: 0xf81d22)
            subTitleLabel.backgroundColor = UIColor(hex: 0xfff2f2)
            failImageView.isHidden = false
            failLabel.isHidden = false
            subTitleLabel.text = "已驳回"
        }
        failLabel.text = data.reject_reason
        titleLabel.text = "旅行证件"
        alertLabel.text = "要求：中国籍上传港澳通行证正反面，外籍上传护照正反面"
        if isOneYearAfter(data.certificates_info.sign_expire_date) && data.certificates_info.sign_expire_date.count != 0 {
            failLabel.text = "证件有效期至少需1年，请更新证件后上传"
            failImageView.isHidden = false
            failLabel.isHidden = false
        } else {

        }
    }
    
    func isOneYearAfter(_ dateString: String) -> Bool {
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd"
        
        guard let inputDate = dateFormatter.date(from: dateString) else {
            return false // 输入格式不正确
        }
        
        let currentDate = Date()
        let oneYearFromNow = Calendar.current.date(byAdding: .year, value: 1, to: currentDate)!
        
        return inputDate < oneYearFromNow
    }
}
