//
//  YHAdopterMarryCardTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterMarryCardTableViewCell: UITableViewCell {
    typealias UrlBlock = (_ url: String, _ index: Int) -> Void
    var urlBlock: UrlBlock?
    var deleteBlock: UrlBlock?
    var frontLabel: UILabel!
    var backSurfaceLabel: UILabel!
    var thirdLabel: UILabel!
    var frontImageButton: YHCardButton!
    var backSurfaceImageButton: YHCardButton!
    var thirdImageButton: YHCardButton!
    var frontDeleteButton: UIButton!
    var backSurfaceDeleteButton: UIButton!
    var thirdDeleteButton: UIButton!
    var activityIndicator: UIActivityIndicatorView!
    var viewModel: YHBaseViewModel = YHBaseViewModel()
    var firstUrl: String = ""
    var secondUrl: String = ""
    var lastUrl: String = ""
    var urls: [String]? {
        didSet {
            guard let firstUrl = urls?.first, firstUrl.count != 0 else { return }
            self.firstUrl = firstUrl
            self.viewModel.getPublicImageUrl(firstUrl) {[weak self] success, _ in
                guard let self = self else { return }
                guard let url = success else { return }
                self.frontImageButton.kf.setBackgroundImage(with: URL(string: url), for: .normal, completionHandler: { _ in
                    self.frontDeleteButton.isHidden = false
                    if self.state == 1 || self.state == 3 {
                        self.frontDeleteButton.isHidden = true
                    }
                })
                self.frontImageButton.setContent("", "")
            }
            guard let secondUrl = urls?.first, secondUrl.count != 0 else { return }
            self.secondUrl = secondUrl
            self.viewModel.getPublicImageUrl(firstUrl) {[weak self] success, _ in
                guard let self = self else { return }
                guard let url = success else { return }
                self.frontImageButton.kf.setBackgroundImage(with: URL(string: url), for: .normal, completionHandler: { _ in
                    self.thirdDeleteButton.isHidden = false
                    if self.state == 1 || self.state == 3 {
                        self.thirdDeleteButton.isHidden = true
                    }
                })
                self.thirdImageButton.setContent("", "")
            }
            guard let lastUrl = urls?.last, lastUrl.count != 0 else { return }
            self.lastUrl = lastUrl
            self.viewModel.getPublicImageUrl(lastUrl) {[weak self] success, _ in
                guard let self = self else { return }
                guard let url = success else { return }
                self.backSurfaceImageButton.kf.setBackgroundImage(with: URL(string: url), for: .normal, completionHandler: { _ in
                    self.backSurfaceDeleteButton.isHidden = false
                    if self.state == 1 || self.state == 3 {
                        self.backSurfaceDeleteButton.isHidden = true
                    }
                })
                self.backSurfaceImageButton.setContent("", "")
            }
            
        }
    }

    var state: Int? {
        didSet {
            if state == 1 || state == 3 {
                frontDeleteButton.isHidden = true
                backSurfaceDeleteButton.isHidden = true
                thirdDeleteButton.isHidden = true
//                frontImageButton.isEnabled = false
//                backSurfaceImageButton.isEnabled = false
//                thirdImageButton.isEnabled = false
            }
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        
        let lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        contentView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
        
        frontLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.mainTextColor50
            label.text = "证件页1"
            label.textAlignment = .center
            return label
        }()
        contentView.addSubview(frontLabel)
        frontLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(self.snp.centerX)
            make.top.equalTo(28)
            make.height.equalTo(20)
        }
        
        backSurfaceLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.mainTextColor50
            label.textAlignment = .center
            label.text = "证件页2"
            return label
        }()
        contentView.addSubview(backSurfaceLabel)
        backSurfaceLabel.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.left.equalTo(self.snp.centerX)
            make.top.equalTo(28)
            make.height.equalTo(20)
        }
        
        thirdLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.mainTextColor50
            label.text = "证件页3"
            label.textAlignment = .center
            return label
        }()
        contentView.addSubview(thirdLabel)
        thirdLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(self.snp.centerX)
            make.top.equalTo(185)
            make.height.equalTo(20)
        }
        
        frontImageButton = {
            let button = YHCardButton()
            button.setContent("card_upload", "点击上传")
            button.setBackgroundImage(UIImage(named: "service_adopter_card_marry_front"), for: .normal)
            button.addTarget(self, action: #selector(frontImageClick), for: .touchUpInside)
            button.layer.cornerRadius = 4
            button.clipsToBounds = true
            return button
        }()
        contentView.addSubview(frontImageButton)
        frontImageButton.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalTo(60)
            make.height.equalTo(99)
            make.width.equalTo(CGFloat(160).fix)
        }
        
        frontDeleteButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "service_card_delete"), for: .normal)
            button.addTarget(self, action: #selector(frontDeleteClick), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        contentView.addSubview(frontDeleteButton)
        frontDeleteButton.snp.makeConstraints { make in
            make.centerX.equalTo(frontImageButton.snp.right)
            make.centerY.equalTo(frontImageButton.snp.top)
            make.height.equalTo(21)
            make.width.equalTo(21)
        }
        
        backSurfaceImageButton = {
            let button = YHCardButton()
            button.setContent("card_upload", "点击上传")
            button.setBackgroundImage(UIImage(named: "service_adopter_card_marry_second"), for: .normal)
            button.addTarget(self, action: #selector(backSurfaceImageClick), for: .touchUpInside)
            button.layer.cornerRadius = 4
            button.clipsToBounds = true
            return button
        }()
        contentView.addSubview(backSurfaceImageButton)
        backSurfaceImageButton.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.top.equalTo(60)
            make.height.equalTo(99)
            make.width.equalTo(CGFloat(160).fix)
        }

        backSurfaceDeleteButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "service_card_delete"), for: .normal)
            button.addTarget(self, action: #selector(backSurfaceDeleteClick), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        contentView.addSubview(backSurfaceDeleteButton)
        backSurfaceDeleteButton.snp.makeConstraints { make in
            make.centerX.equalTo(backSurfaceImageButton.snp.right)
            make.centerY.equalTo(backSurfaceImageButton.snp.top)
            make.height.equalTo(21)
            make.width.equalTo(21)
        }
        
        thirdImageButton = {
            let button = YHCardButton()
            button.setContent("card_upload", "点击上传")
            button.setBackgroundImage(UIImage(named: "service_adopter_card_marry_back"), for: .normal)
            button.addTarget(self, action: #selector(thirdImageClick), for: .touchUpInside)
            button.layer.cornerRadius = 4
            button.clipsToBounds = true
            return button
        }()
        contentView.addSubview(thirdImageButton)
        thirdImageButton.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalTo(219)
            make.height.equalTo(99)
            make.width.equalTo(CGFloat(160).fix)
        }
        
        thirdDeleteButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "service_card_delete"), for: .normal)
            button.addTarget(self, action: #selector(thirdDeleteClick), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        contentView.addSubview(thirdDeleteButton)
        thirdDeleteButton.snp.makeConstraints { make in
            make.centerX.equalTo(thirdImageButton.snp.right)
            make.centerY.equalTo(thirdImageButton.snp.top)
            make.height.equalTo(21)
            make.width.equalTo(21)
        }
        
        activityIndicator = {
            let view = UIActivityIndicatorView()
            view.style = .medium
            return view
        }()
        contentView.addSubview(activityIndicator)
        activityIndicator.snp.makeConstraints { make in
            make.center.equalTo(backSurfaceImageButton.snp.center)
            make.height.equalTo(25)
            make.width.equalTo(25)
        }
        
    }
    
    @objc func frontImageClick() {
        if firstUrl.count != 0 {
            let vc = YHImageViewController()
            vc.imgString = firstUrl
            UIViewController.current?.navigationController?.pushViewController(vc)
            return
        }
        if state == 1 || state == 3 {
            return
        }
        YHImagePickerView.show {[weak self] image in
            guard let self = self else { return }
            self.frontImageButton.setContent("card_loading", "上传中")
            self.frontImageButton.startRotationAnimation()
            self.viewModel.uploadImage(image) {[weak self] success, _ in
                guard let self = self else { return }
                self.frontImageButton.stopRotationAnimation()
                self.frontImageButton.setContent("", "")
                
                guard let url = success else { return }
                self.frontImageButton.setBackgroundImage(image, for: .normal)
                self.frontDeleteButton.isHidden = false
                if let block = self.urlBlock {
                    block(url, 0)
                }
            }
        }
    }
    
    @objc func backSurfaceImageClick() {
        if secondUrl.count != 0 {
            let vc = YHImageViewController()
            vc.imgString = secondUrl
            UIViewController.current?.navigationController?.pushViewController(vc)
            return
        }
        if state == 1 || state == 3 {
            return
        }
        YHImagePickerView.show {[weak self] image in
            guard let self = self else { return }
            self.backSurfaceImageButton.setContent("card_loading", "上传中")
            self.backSurfaceImageButton.startRotationAnimation()
            self.viewModel.uploadImage(image) {[weak self] success, _ in
                guard let self = self else { return }
                self.backSurfaceImageButton.stopRotationAnimation()
                self.backSurfaceImageButton.setContent("", "")
                
                guard let url = success else { return }
                self.backSurfaceImageButton.setBackgroundImage(image, for: .normal)
                self.backSurfaceDeleteButton.isHidden = false
                if let block = self.urlBlock {
                    block(url, 1)
                }
            }
        }
        
    }
    
    @objc func thirdImageClick() {
        if lastUrl.count != 0 {
            let vc = YHImageViewController()
            vc.imgString = lastUrl
            UIViewController.current?.navigationController?.pushViewController(vc)
            return
        }
        if state == 1 || state == 3 {
            return
        }
        YHImagePickerView.show {[weak self] image in
            guard let self = self else { return }
            self.thirdImageButton.setContent("card_loading", "上传中")
            self.thirdImageButton.startRotationAnimation()
            self.viewModel.uploadImage(image) {[weak self] success, _ in
                guard let self = self else { return }
                self.thirdImageButton.stopRotationAnimation()
                self.thirdImageButton.setContent("", "")
                
                guard let url = success else { return }
                self.thirdImageButton.setBackgroundImage(image, for: .normal)
                self.thirdDeleteButton.isHidden = false
                if let block = self.urlBlock {
                    block(url, 2)
                }
            }
        }
    }
    
    @objc func frontDeleteClick() {
        firstUrl = ""
        frontDeleteButton.isHidden = true
        frontImageButton.setBackgroundImage(UIImage(named: "service_adopter_card_marry_front"), for: .normal)
        frontImageButton.setContent("card_upload", "点击上传")
        if let block = self.deleteBlock {
            block("", 0)
        }
    }
    
    @objc func backSurfaceDeleteClick() {
        secondUrl = ""
        backSurfaceDeleteButton.isHidden = true
        backSurfaceImageButton.setBackgroundImage(UIImage(named: "service_adopter_card_marry_second"), for: .normal)
        backSurfaceImageButton.setContent("card_upload", "点击上传")
        if let block = self.deleteBlock {
            block("", 1)
        }
    }
    
    @objc func thirdDeleteClick() {
        lastUrl = ""
        thirdDeleteButton.isHidden = true
        thirdImageButton.setBackgroundImage(UIImage(named: "service_adopter_card_marry_back"), for: .normal)
        thirdImageButton.setContent("card_upload", "点击上传")
        if let block = self.deleteBlock {
            block("", 2)
        }
    }
}
