//
//  YHAdopterTravelItemTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterTravelItemTableViewCell: UITableViewCell {
    typealias InformationBlock = (_ model: YHItemModel) -> Void
    var informationBlock: InformationBlock?
    var itemView: YHItemView!
    var state: Int? {
        didSet {
            itemView.state = state ?? 0
        }
    }
    var dataSource: YHItemModel? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        let line = UIView()
        line.backgroundColor = UIColor.separatorColor
        contentView.addSubview(line)
        line.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.bottom.equalTo(0)
            make.height.equalTo(0.5)
            make.right.equalTo(-18)
        }
        itemView = {
            let view = YHItemView()
            return view
        }()
        itemView.block = {[weak self] model in
            guard let self = self else { return }
            if let block = self.informationBlock {
                block(model)
            }
        }
        contentView.addSubview(itemView)
        itemView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(0)
            make.bottom.equalTo(-1)
            make.right.equalTo(-18)
        }
    }
    
    func updateAllViews() {
        itemView.dataSource = dataSource
    }
}
