//
//  YHAdopterNewPeopleViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterNewPeopleViewModel: YHBaseViewModel {
    var mainModel: YHAdopterDependentDataModel = YHAdopterDependentDataModel()
    
    override init() {
        super.init()
    }
    
    func getBaseDataSource(_ isShowPrompt: Bool, _ title: String = "配偶信息") -> [YHSectionItemModel] {
        let item = YHItemModel(id: .id1, isNeed: true, title: "姓名", isUserKeyBoard: true, prompts: "请输入", message: mainModel.info.dep_name, isShowPrompts: isShowPrompt, alertMessage: "请输入姓名")
        var string = ""
        if mainModel.info.dep_nationality == 0 {
            string = "中国大陆"
        } else if mainModel.info.dep_nationality == 1 {
            string = "中国澳门"
        } else if mainModel.info.dep_nationality == 2 {
            string = "中国台湾"
        } else if mainModel.info.dep_nationality == 3 {
            string = "海外地区"
        }
        let item1 = YHItemModel(id: .id2, isNeed: true, title: "国家/地区", isUserKeyBoard: false, prompts: "请选择", message: string, type: .selectAddress, isShowPrompts: isShowPrompt, alertMessage: "请选择国家/地区")
        
        let section = YHSectionItemModel(title: title, models: [item, item1])
        return [section]
    }
    
    func getIdCardInformation() -> [YHAdopterCardModel] {
        let item = YHAdopterCardModel(type: .travel, title: "旅行证件（港澳通行证/护照）", state: 0)
        let item1 = YHAdopterCardModel(type: .china, title: "身份证-正反面", state: 0)
        let item2 = YHAdopterCardModel(type: .resident, title: "户口信息页", state: 0)
        let item3 = YHAdopterCardModel(type: .birth, title: "中国居留许可签证", state: 0)
        let item4 = YHAdopterCardModel(type: .id, title: "2寸白底证件照片", state: 0)
        let item5 = YHAdopterCardModel(type: .other, title: "其他相关证件", state: 0)
        let item6 = YHAdopterCardModel(type: .marry, title: "结婚证", state: 0)
        let item7 = YHAdopterCardModel(type: .chinaTravel, title: "中国旅行证", state: 0)
        let item8 = YHAdopterCardModel(type: .chinaLife, title: "中国居留许可证", state: 0)
        return [item, item1, item2, item3, item4, item5, item6, item7, item8]
    }
    
    func updateModel(_ item: YHItemModel) {
        guard let type = item.id else { return }
        switch type {
        case .id1:
            mainModel.info.dep_name = item.message ?? ""
        case .id2:
            mainModel.info.dep_nationality = item.value?.first?.int ?? 0
        default:
            break
        }
    }
    
    func isCanNext(_ step: Int) -> Bool {
        let depname = mainModel.info.dep_name
        let depnationality = mainModel.info.dep_nationality
        guard depname.count > 0 else { return false }
        guard depnationality < 4 else { return false }
        return true
    }
    
    func getDependentsData(id: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Adopter.dependents
        
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String: Any], let resultModel = YHAdopterDependentDataModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    
                    callBackBlock(false, err)
                    return
                }
                self.mainModel = resultModel
                callBackBlock(true, nil)
            } else {
                
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
                
            }
            
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func postDependentsAdd(id: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        
        let params: [String: Any] = ["id": id,
                                     "is_spouse": mainModel.info.is_spouse,
                                     "order_id": mainModel.info.order_id,
                                     "dep_nationality": mainModel.info.dep_nationality,
                                     "dep_name": mainModel.info.dep_name]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Adopter.dependentsAdd
        
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHAdopterDependentDataModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    
                    callBackBlock(false, err)
                    return
                }
                self.mainModel = resultModel
                callBackBlock(true, nil)
            } else {
                
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
                
            }
            
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func postIsReadAgreement(id: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id,
                                     "is_read_agreement": 1,
                                     "order_id": mainModel.info.order_id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Adopter.isReadAgreement
        
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
            
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func getDependentsCheck(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["order_id": mainModel.info.order_id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Adopter.dependentsCheck
        
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
                
            }
            
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
