//
//  YHPrincipleFileRenameView.swift
//  galaxy
//
//  Created by edy on 2024/8/9.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import IQKeyboardManagerSwift

class YHPrincipleFileRenameView: UIView {

    var confirmBlock: ((String) -> Void)?
    var name: String = "" {
        didSet {
            self.renameInputView.textField.text = name
        }
    }
    
    static func renameView(name: String) -> YHPrincipleFileRenameView {
        let view = YHPrincipleFileRenameView(frame: UIScreen.main.bounds)
        view.name = name
        return view
    }
    
    func show() {
        addKeyBoardNotify()
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
        renameInputView.textField.becomeFirstResponder()
    }
    
    func dismiss() {
        removeNotify()
        self.removeFromSuperview()
    }
    
    var renameInputView: YHFileRenameInputView = {
        let view = YHFileRenameInputView.inputView(defalutText: "请输入名称")
        return view
    }()
    
    // 底层蒙版
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = .alertMaskColor
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    deinit {
        self.removeNotify()
    }
    
    func createUI() {
        
        self.addSubview(blackMaskView)
        self.addSubview(renameInputView)
        
        renameInputView.editBlock = {
            [weak self] text in
            guard let self = self else { return }
            if let text = text {
                confirmBlock?(text)
            }
            self.dismiss()
        }
        renameInputView.dismissBlock = {
            self.dismiss()
        }
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        renameInputView.snp.makeConstraints { make in
            make.left.right.equalTo(self)
            make.height.equalTo(YHFileRenameInputView.height)
            make.bottom.equalToSuperview().offset(YHFileRenameInputView.height)
        }
    }
    
    func addKeyBoardNotify() {
        
        NotificationCenter.default.addObserver(self, selector: #selector(handleKeyboardNotification(_:)), name: UIResponder.keyboardWillShowNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(handleKeyboardNotification(_:)), name: UIResponder.keyboardWillHideNotification, object: nil)
    }
    
    func removeNotify() {
        NotificationCenter.default.removeObserver(self)
    }
    
    @objc func handleKeyboardNotification(_ notification: Notification) {
        
        if notification.userInfo != nil {
            
            guard let keyboardFrame = (notification.userInfo?[UIResponder.keyboardFrameEndUserInfoKey] as AnyObject).cgRectValue else {return }

            let isKeyboardShow = notification.name == UIResponder.keyboardWillShowNotification
            let bottomMargin = (isKeyboardShow ? -keyboardFrame.height : YHFileRenameInputView.height)
            
            if !isKeyboardShow {
                IQKeyboardManager.shared.isEnabled = true
            }
            
            self.renameInputView.snp.updateConstraints { make in
                make.bottom.equalToSuperview().offset(bottomMargin)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
            
            if !isKeyboardShow {
                self.dismiss()
            }
        }
    }
}
