//
//  YHFileListHeaerView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHFileListHeaerView: UIView {
    static let viewH: CGFloat = 312
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private lazy var topBkg: UIView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "file_list_bkg")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    private lazy var imageV1: UIView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "file_list_wenzi")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    private lazy var imageV2: UIView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "file_list_icon")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    // 待提交
    private lazy var waitSubmitLable: UILabel = {
        let imagV = UILabel()
        imagV.text = "您有  项待提交"
        imagV.font = UIFont.PFSC_R(ofSize: 14)
        imagV.textColor = UIColor.white
        return imagV
    }()
    
    // 重传
    private lazy var reuploadLable: UILabel = {
        let imagV = UILabel()
        imagV.text = "您有   项需重传"
        imagV.font = UIFont.PFSC_R(ofSize: 14)
        imagV.textColor = UIColor.white
        return imagV
    }()
    
    var dataModel: YHCertificateEntryModel? {
        didSet {
            updateUI()
        }
    }
}

private extension YHFileListHeaerView {
    func initView() {
        addSubview(topBkg)
        topBkg.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalToSuperview()
            make.width.equalTo(KScreenWidth)
            make.height.equalTo(YHFileListHeaerView.viewH)
        }
        
        addSubview(imageV1)
        imageV1.snp.makeConstraints { make in
            make.top.equalTo(34)
            make.left.equalTo(28)
            make.width.equalTo(222)
            make.height.equalTo(86)
        }
        
        addSubview(imageV2)
        imageV2.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(98)
            make.left.equalTo(KScreenWidth - kMargin - 154)
            make.width.equalTo(154)
            make.height.equalTo(130)
        }
        
        let imagVDot1 = UIImageView()
        imagVDot1.image = UIImage(named: "file_list_dot")
        imagVDot1.contentMode = .scaleAspectFill
        addSubview(imagVDot1)
        imagVDot1.snp.makeConstraints { make in
            make.left.equalTo(28)
            make.top.equalTo(imageV1.snp.bottom).offset(21)
            make.width.height.equalTo(8)
        }
        
        let imagVBkg1 = UIImageView()
        imagVBkg1.image = UIImage(named: "file_list_icon_bkg")
        imagVBkg1.contentMode = .scaleAspectFill
        addSubview(imagVBkg1)
        imagVBkg1.snp.makeConstraints { make in
            make.left.equalTo(imagVDot1.snp.right).offset(10)
            make.centerY.equalTo(imagVDot1)
            make.width.equalTo(148)
            make.height.equalTo(23)
        }
        
        let imagVDot2 = UIImageView()
        imagVDot2.image = UIImage(named: "file_list_dot")
        imagVDot2.contentMode = .scaleAspectFill
        addSubview(imagVDot2)
        imagVDot2.snp.makeConstraints { make in
            make.left.equalTo(28)
            make.top.equalTo(imagVDot1.snp.bottom).offset(25)
            make.width.height.equalTo(8)
        }
        
        let imagVBkg2 = UIImageView()
        imagVBkg2.image = UIImage(named: "file_list_icon_bkg")
        imagVBkg2.contentMode = .scaleAspectFill
        addSubview(imagVBkg2)
        imagVBkg2.snp.makeConstraints { make in
            make.left.equalTo(imagVDot2.snp.right).offset(10)
            make.centerY.equalTo(imagVDot2)
            make.width.equalTo(148)
            make.height.equalTo(23)
        }
        
       addSubview(waitSubmitLable)
        waitSubmitLable.snp.makeConstraints { make in
            make.centerY.equalTo(imagVDot1)
            make.left.equalTo(imagVDot1.snp.right).offset(20)
            make.height.equalTo(21)
            make.right.equalTo(imagVBkg1.snp.right).offset(4)
            
        }
        
        addSubview(reuploadLable)
        reuploadLable.snp.makeConstraints { make in
            make.centerY.equalTo(imagVDot2)
            make.left.equalTo(imagVDot2.snp.right).offset(20)
            make.height.equalTo(21)
            make.right.equalTo(imagVBkg2.snp.right).offset(4)
             
         }
        
    }
    
    func updateUI() {
        guard let dataModel = dataModel else { return }
        
        let a: ASAttributedString = .init("您有 ", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.white))
        let aa: ASAttributedString = .init(NSAttributedString(string: String(dataModel.to_be_submit_num)), .font(UIFont.PFSC_B(ofSize: 15)), .foreground(UIColor(hex: 0xFFE6B5, alpha: 1.0)))
        let aaa: ASAttributedString = .init(" 项待提交", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.white))
        waitSubmitLable.attributed.text = a + aa + aaa
        
        let bb: ASAttributedString = .init(NSAttributedString(string: String(dataModel.reject_num)), .font(UIFont.PFSC_B(ofSize: 15)), .foreground(UIColor(hex: 0xFFE6B5, alpha: 1.0)))
        
        let bbb: ASAttributedString = .init(" 项需重传", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.white))
        reuploadLable.attributed.text = a + bb + bbb
    }
}
