//
//  YHQuestionAndAnswerCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/17.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHQuestionAndAnswerCell: UITableViewCell {
    static let cellReuseIdentifier = "YHQuestionAndAnswerCell"
    
    var dataModel: YHQuestionAndAnswerModel? {
        didSet {
            updateUI()
        }
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var contractNameLable = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.font = UIFont.PFSC_M(ofSize: 16)
        lable.text = "--"
        lable.numberOfLines = 0
        lable.lineBreakMode = .byCharWrapping
        return lable
    }()
    
    lazy var contractIdLable = {
        let lable = UILabel()
        lable.textColor = UIColor.labelTextColor2
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.text = "--"
        lable.numberOfLines = 0
        lable.lineBreakMode = .byCharWrapping
        return lable
    }()
}

extension YHQuestionAndAnswerCell {
    func updateUI() {
        guard let dataModel = dataModel else { return }
        contractNameLable.text = dataModel.question
        contractIdLable.text = dataModel.answer
    }
    
    func setupUI() {
        let holdView = UIView()
        holdView.backgroundColor = .white
        holdView.layer.cornerRadius = kCornerRadius6
        holdView.clipsToBounds = true
        
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        contentView.addSubview(holdView)
        holdView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
        }
        
        holdView.addSubview(contractNameLable)
        contractNameLable.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(kMargin)
            make.left.equalToSuperview().offset(44)
            make.right.equalTo(-kMargin)
        }
        
        let nextImgV = UIImageView()
        nextImgV.image = UIImage(named: "my_cer_question_icon")
        nextImgV.contentMode = .scaleAspectFill
        holdView.addSubview(nextImgV)
        nextImgV.snp.makeConstraints { make in
            make.top.equalTo(contractNameLable.snp.top)
            make.left.equalTo(kMargin)
            make.width.height.equalTo(21)
        }
        
        holdView.addSubview(contractIdLable)
        contractIdLable.snp.makeConstraints { make in
            make.top.equalTo(contractNameLable.snp.bottom).offset(12)
            make.right.equalTo(-kMargin)
            make.left.equalTo(kMargin)
            make.height.greaterThanOrEqualTo(20)
            make.bottom.equalTo(-kMargin)
        }
    }
}
