//
//  YHComprehensiveEvaluationCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

enum YHSchemeTipsType: Int {
    case none = 0
    case neverPass = 1 // 要求一项都不满足
    case pass = 2 // 要求满足了6项以上 通过
    case partPass = 3 // 要求未满足6项 不通过
}

class YHComprehensiveEvaluationCell: UITableViewCell {

    static let cellReuseIdentifier = "YHComprehensiveEvaluationCell"
    
    var tipsType: YHSchemeTipsType = .none {
        didSet {
            if tipsType == .neverPass {
                tipsLabel.attributed.text = neverPassText
                
            } else if tipsType == .partPass {
                tipsLabel.attributed.text = partPassText

            } else if tipsType == .pass {
                tipsLabel.attributed.text = passText
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var markImgV: UIImageView = {
        let v = UIImageView(image: UIImage(named: "my_scheme_mark"))
        return v
    }()
    
    lazy var evaluationLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 17)
        label.textColor = .mainTextColor
        label.text = "综合评估"
        return label
    }()
    
    lazy var yellowContentView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.init(hex: 0xCF9764, alpha: 0.12)
        view.layer.cornerRadius = 4.0
        view.clipsToBounds = true
        return view
    }()
    
    lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.attributed.text = neverPassText
        return label
    }()
    
    lazy var passText: ASAttributedString = {
        let aa: ASAttributedString = .init("经初步评估，", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
        let bb: ASAttributedString = .init("您符合【优秀人才入境计划-综合计分制】甄选条件", .font(UIFont.PFSC_B(ofSize: 14)), .foreground(UIColor.init(hex: 0xD48638)))
        let cc: ASAttributedString = .init("，您在以下方面具备明显优势，为您感到开心！接下来辛苦您根据指引配合准备申请材料", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
        return aa+bb+cc
    }()
    
    lazy var partPassText: ASAttributedString = {
//        let aa: ASAttributedString = .init("经初步评估，", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor))
//        let bb: ASAttributedString = .init("您目前已符合【优秀人才入境计划 - 综合计分制】的部分重要甄选条件", .font(UIFont.PFSC_B(ofSize: 14)),.foreground(UIColor.init(hex: 0xD48638)))
//        let cc: ASAttributedString = .init("，在如下方面具备优势，足以证明您的优秀之处！考虑到优才计划的的多维度要求，以及您目前已经具备的良好基础，如果您能进一步去孵化其他条件，后续的申请将会更具竞争力", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor))
        
       let aa: ASAttributedString = .init("       综合计分制设有资格门槛，只有达到申请资格门槛的申请人才能经网上递交申请。", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
       let bb: ASAttributedString = .init("最新适用的申请资格门槛：符合12项评核标准的其中6个。\n", .font(UIFont.PFSC_B(ofSize: 14)), .foreground(UIColor.init(hex: 0xD48638)))
        
       let cc: ASAttributedString = .init("       经初步评估，", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
        let dd: ASAttributedString = .init("您目前符合【优秀人才入境计划 - 综合计分制】的以下甄选条件！", .font(UIFont.PFSC_B(ofSize: 14)), .foreground(UIColor.mainTextColor))
       let ee: ASAttributedString = .init("考虑到您目前已经具备的良好基础，建议您进一步孵化其他条件。", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
        
        return aa+bb+cc+dd+ee
    }()
    
    lazy var neverPassText: ASAttributedString = {
        let aa: ASAttributedString = .init("经初步评估，", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
        let bb: ASAttributedString = .init("您目前不符合【优秀人才入境计划-综合计分制】甄选条件", .font(UIFont.PFSC_B(ofSize: 14)), .foreground(UIColor.init(hex: 0xD48638)))
        let cc: ASAttributedString = .init("，考虑到优才计划的的多维度要求，我们建议您进一步孵化以下条件，后续的申请将会更具竞争力", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
        return aa+bb+cc
    }()
    
    lazy var bgView: UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        return view
    }()
    
    lazy var whiteBottomView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        
        contentView.addSubview(bgView)
        contentView.addSubview(whiteBottomView)
        contentView.addSubview(markImgV)
        contentView.addSubview(evaluationLabel)
        contentView.addSubview(yellowContentView)
        yellowContentView.addSubview(tipsLabel)
        
        bgView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.equalToSuperview()
            make.height.equalTo(416)
        }
        
        whiteBottomView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.equalTo(bgView.snp.bottom).offset(0)
            make.bottom.equalToSuperview()
        }

        markImgV.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.width.equalTo(4)
            make.height.equalTo(16)
            make.centerY.equalTo(evaluationLabel)
        }
        
        evaluationLabel.snp.makeConstraints { make in
            make.top.equalTo(238)
            make.height.equalTo(24)
            make.left.equalTo(markImgV.snp.right).offset(8)
            make.right.equalTo(-32)
        }
        
        yellowContentView.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(evaluationLabel.snp.bottom).offset(16)
            make.bottom.equalTo(-24)
        }
        
        tipsLabel.snp.makeConstraints { make in
            make.left.equalTo(12)
            make.right.equalTo(-12)
            make.top.equalTo(12)
            make.bottom.equalTo(-12)
        }
    }

}
