//
//  YHIHKIdentityPlanCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHIHKIdentityPlanCell: UITableViewCell {

    static let cellReuseIdentifier = "YHIHKIdentityPlanCell"
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        let aa: ASAttributedString = .init("了解更多", .font(UIFont.PFSC_B(ofSize: 18)), .foreground(UIColor.mainTextColor))
        let bb: ASAttributedString = .init("香港身份计划", .font(UIFont.PFSC_B(ofSize: 18)), .foreground(UIColor.brandMainColor))
        label.attributed.text = aa+bb
        return label
    }()
    
    lazy var subtitleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor(alpha: 0.5)
        label.text = "助您香港身份申请无忧"
        return label
    }()
    
    lazy var knowBtn: UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("立即了解", for: .normal)
        btn.setTitleColor(.white, for: .normal)
        btn.backgroundColor = .brandMainColor
        btn.titleLabel?.font = .PFSC_M(ofSize: 12)
        return btn
    }()
    
    lazy var bgImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "my_shceme_plan_bg"))
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        contentView.backgroundColor = .clear
        self.backgroundColor = .clear
        selectionStyle = .none
        
        contentView.addSubview(bgImgView)
        
        bgImgView.snp.makeConstraints { make in
            make.left.equalTo(17)
            make.right.equalTo(-17)
            make.top.equalToSuperview()
            make.height.equalTo(bgImgView.snp.width).multipliedBy(93.0/341.0)
            make.bottom.equalTo(-33)
        }
        
//        titleLabel.snp.makeConstraints { make in
//            make.left.equalTo(18)
//            make.top.equalTo(22)
//            make.height.equalTo(25)
//        }
//        
//        subtitleLabel.snp.makeConstraints { make in
//            make.left.equalTo(18)
//            make.top.equalTo(titleLabel.snp.bottom).offset(4)
//            make.height.equalTo(20)
//        }
//        
//        knowBtn.snp.makeConstraints { make in
//            make.right.equalTo(-24)
//            make.centerY.equalToSuperview()
//            make.width.equalTo(72)
//            make.height.equalTo(32)
//        }
    }
}
