//
//  YHImproveHKView.swift
//  galaxy
//
//  Created by Dufet on 2024/11/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHImproveHKView: UIView {

    var item = YHImproveDetailModel() {
        didSet {
            titleLabel.text = "港府要求：\(item.hk_require)"
            tipsLabel.text = item.improve_content
            showTemplateBtn = item.templates.count > 0
        }
    }
    
    var showTemplateBtn: Bool = true {
        didSet {
            templateBtn.isHidden = !showTemplateBtn
            templateBtn.snp.updateConstraints { make in
                make.height.equalTo(showTemplateBtn ? 20 : 0)
                make.bottom.equalTo(showTemplateBtn ? -14 : 0)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    lazy var grayView: UIView = {
        let view = UIView()
        view.layer.cornerRadius = 4.0
        view.clipsToBounds = true
        view.backgroundColor = .init(hex: 0xF8F9FB)
        return view
    }()
    
    lazy var numImgView: UIImageView = {
        
        let iconV = UIImageView(image: UIImage(named: "my_scheme_num_bg"))
        iconV.addSubview(numLabel)
        
        numLabel.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.centerX.equalToSuperview()
            make.height.equalTo(20)
        }
        return iconV
    }()
    
    lazy var numLabel: UILabel = {
        let label = UILabel()
        label.text = "19"
        label.font = UIFont(name: "DINAlternate-Bold", size: 14)
        label.textColor = .white
        return label
    }()
    
    lazy var markView: UIView = {
        let view = UIView()
        view.backgroundColor = .brandMainColor
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_M(ofSize: 14)
        label.textColor = .mainTextColor
        return label
    }()
    
    lazy var improveTargetContentView: UIView = {
        let view = UIView()
        view.layer.cornerRadius = 2.0
        view.clipsToBounds = true
        view.backgroundColor = .white
        return view
    }()
    
    lazy var iconImgView: UIImageView = {
        let v = UIImageView(image: UIImage(named: "my_scheme_improve_icon"))
        return v
    }()
    
    lazy var subtitleLabel: UILabel = {
        let label = UILabel()
        label.text = "提升方向"
        label.font = UIFont.PFSC_B(ofSize: 14)
        label.textColor = .mainTextColor
        return label
    }()
    
    lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.textColor = .init(hex: 0x6D788A)
        return label
    }()
    
    lazy var templateBtn: UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("材料示例", for: .normal)
        btn.setTitleColor(.brandMainColor, for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 14)
        btn.setImage(UIImage(named: "blue_right_arrow"), for: .normal)
        btn.YH_clickEdgeInsets = UIEdgeInsets(top: 10, left: 20, bottom: 20, right: 10)
        btn.addTarget(self, action: #selector(didRightBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    lazy var templateListView: YHImproveSchemeTemplateListView = {
        let view = YHImproveSchemeTemplateListView.listView()
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: .zero)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func didRightBtnClicked() {
       self.templateListView.items = item.templates
       self.templateListView.show()
    }
    
    func setupUI() {
        
        self.addSubview(grayView)
        self.addSubview(markView)
        self.addSubview(titleLabel)
        self.addSubview(numImgView)
        self.addSubview(improveTargetContentView)
        improveTargetContentView.addSubview(iconImgView)
        improveTargetContentView.addSubview(subtitleLabel)
        improveTargetContentView.addSubview(tipsLabel)
        improveTargetContentView.addSubview(templateBtn)

        grayView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        markView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.top.equalTo(titleLabel).offset(3)
            make.width.equalTo(3)
            make.height.equalTo(12)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(markView.snp.right).offset(9)
            make.top.equalTo(16)
            make.right.equalTo(numImgView.snp.left).offset(-5)
        }
        
        numImgView.snp.makeConstraints { make in
            make.top.equalTo(0)
            make.right.equalTo(-8)
            make.width.equalTo(19)
            make.height.equalTo(22)
        }
        
        improveTargetContentView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(16)
            make.left.equalTo(8)
            make.right.equalTo(-8)
            make.bottom.equalTo(-8)

        }

        iconImgView.snp.makeConstraints { make in
            make.width.height.equalTo(18)
            make.left.top.equalTo(12)
        }
        
        subtitleLabel.snp.makeConstraints { make in
            make.left.equalTo(iconImgView.snp.right).offset(6)
            make.centerY.equalTo(iconImgView)
            make.height.equalTo(20)
        }
        
        tipsLabel.snp.makeConstraints { make in
            make.left.equalTo(12)
            make.right.equalTo(-12)
            make.top.equalTo(subtitleLabel.snp.bottom).offset(8)
        }
        
        templateBtn.snp.makeConstraints { make in
            make.left.equalTo(12)
            make.top.equalTo(tipsLabel.snp.bottom).offset(12)
            make.width.equalTo(76)
            make.height.equalTo(20)
            make.bottom.equalTo(-14)
        }
        templateBtn.iconInRight(with: 0)
    }

}
