//
//  YHImproveSchemeTemplateListCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHImproveSchemeTemplateListCell: UITableViewCell {

    static let cellReuseIdentifier = "YHImproveSchemeTemplateListCell"
        
    var model = YHSchemeTemplatesModel()
    var clickBlock: ((YHSchemeTemplatesModel) -> Void)?

    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .init(hex: 0xE9ECF0)
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor
        label.numberOfLines = 0
        return label
    }()
    
    lazy var rightBtn: UIButton = {
        let btn = UIButton()
        btn.backgroundColor = .init(hex: 0xF5F6F8)
        btn.setTitle("查看示例", for: .normal)
        btn.setTitleColor(.mainTextColor, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 11)
        btn.addTarget(self, action: #selector(didBtnClicked), for: .touchUpInside)
        btn.layer.cornerRadius = kCornerRadius2
        return btn
    }()
    
    @objc func didBtnClicked() {
        clickBlock?(model)
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        contentView.clipsToBounds = true
        
        contentView.addSubview(titleLabel)
        contentView.addSubview(rightBtn)
        contentView.addSubview(lineView)

        lineView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.top.equalTo(16)
            make.bottom.equalTo(-16)
            make.right.equalTo(rightBtn.snp.left).offset(-15)
        }
        
        rightBtn.snp.makeConstraints { make in
            make.width.equalTo(60)
            make.height.equalTo(25)
            make.right.equalTo(0)
            make.centerY.equalToSuperview()
        }
    }
}
