//
//  YHImproveTargetCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHImproveTargetCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHImproveTargetCell"
    
    var submitClick: (() -> Void)?

    var unpassArr: [YHComprehensiveEevaluationModel] = [] {
        didSet {
            updateRequireArrUI()
        }
    }
    
    func updateRequireArrUI() {
        listView.removeSubviews()
        var lastView: YHImproveRequireItemView?
        for (index, item) in unpassArr.enumerated() {
            let view = YHImproveRequireItemView(frame: .zero)
            view.item = item
            listView.addSubview(view)
            view.snp.makeConstraints { make in
                make.left.right.equalToSuperview()
                if let lastView = lastView {
                    make.top.equalTo(lastView.snp.bottom).offset(16)
                } else {
                    make.top.equalTo(0)
                }
                if index == unpassArr.count-1 {
                    make.bottom.equalTo(0)
                }
            }
            lastView = view
        }
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 6
        view.clipsToBounds = true
        return view
    }()
    
    lazy var topBgView: UIImageView = {
        let imgV = UIImageView(image: UIImage(named: "my_scheme_improve_bg"))
        return imgV
    }()
    
    lazy var markImgV: UIImageView = {
        let v = UIImageView(image: UIImage(named: "my_scheme_mark"))
        return v
    }()
    
    lazy var improveLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 17)
        label.textColor = .mainTextColor
        label.text = "提升目标"
        return label
    }()
    
    lazy var optionsLabel: UILabel = {
        let optionsLabel = UILabel()
        optionsLabel.text = "多选"
        optionsLabel.textAlignment = .center
        optionsLabel.font = .PFSC_M(ofSize: 11)
        optionsLabel.textColor = .init(hex: 0x949494)
        optionsLabel.layer.cornerRadius = 4.0
        optionsLabel.clipsToBounds = true
        optionsLabel.backgroundColor = .init(hex: 0x949494, alpha: 0.12)
        optionsLabel.frame = CGRect(x: 0, y: 0, width: 30, height: 16)
        return optionsLabel
    }()
    
    private lazy var titleLabel: UITextView  = {
        
        let lable0 = UITextView()
        lable0.isScrollEnabled = false
        lable0.isEditable = false
        lable0.isSelectable = false
        lable0.backgroundColor = .clear
        
        let title: ASAttributedString = .init(string: "请选择您的提升目标，我们将为您生成专属提升方案~", .font(UIFont.PFSC_M(ofSize: 15)), .foreground(UIColor.mainTextColor))
        var options: ASAttributedString = "  \(.view(optionsLabel, .original(.center)))"
        lable0.attributed.text = title + options
        return lable0
    }()
        
    lazy var listView: UIView = {
        let view = UIView()
        return view
    }()
    
    lazy var bottomBtn: UIButton = {
        let btn = UIButton()
        btn.backgroundColor = .init(hex: 0xD48638)
        btn.setTitleColor(.white, for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 16)
        btn.layer.cornerRadius = 3
        btn.setTitle("提交，获取详细方案", for: .normal)
        btn.addTarget(self, action: #selector(didBottomBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    @objc func didBottomBtnClicked() {
        submitClick?()
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        contentView.clipsToBounds = true
        
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(topBgView)
        whiteContentView.addSubview(markImgV)
        whiteContentView.addSubview(improveLabel)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(listView)
        whiteContentView.addSubview(bottomBtn)

        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.bottom.equalToSuperview()
        }
        
        topBgView.snp.makeConstraints { make in
            make.left.top.right.equalToSuperview()
            make.height.equalTo(105)
        }
        
        markImgV.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.width.equalTo(4)
            make.height.equalTo(16)
            make.centerY.equalTo(improveLabel)
        }
        
        improveLabel.snp.makeConstraints { make in
            make.top.equalTo(24)
            make.height.equalTo(24)
            make.left.equalTo(markImgV.snp.right).offset(8)
            make.right.equalTo(-24)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(improveLabel.snp.bottom).offset(16)
        }
        
        listView.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(titleLabel.snp.bottom).offset(16)
        }
        
        bottomBtn.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(listView.snp.bottom).offset(24)
            make.bottom.equalTo(-24)
            make.height.equalTo(46)
        }
    }
}
