//
//  YHModifySchemeInfoCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHModifySchemeInfoCell: UITableViewCell {

    static let cellReuseIdentifier = "YHModifySchemeInfoCell"

    var modifyBlock: (() -> Void)?
    
    lazy var bottomBtn: UIButton = {
        let btn = UIButton()
        btn.backgroundColor = .white
        btn.setTitleColor(.init(hex: 0xD48638), for: .normal)
        btn.layer.borderColor = UIColor.init(hex: 0xD48638).cgColor
        btn.layer.borderWidth = 1.0
        btn.titleLabel?.font = .PFSC_M(ofSize: 16)
        btn.layer.cornerRadius = 3
        btn.setTitle("修改信息", for: .normal)
        btn.addTarget(self, action: #selector(didBottomBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    @objc func didBottomBtnClicked() {
        modifyBlock?()
    }
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.clipsToBounds = true
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        contentView.clipsToBounds = true
        
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(bottomBtn)
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.bottom.equalToSuperview()
        }
        
        bottomBtn.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(0)
            make.bottom.equalTo(-24)
            make.height.equalTo(46)
        }
    }
    
//    override func layoutSubviews() {
//        super.layoutSubviews()
//        let path = UIBezierPath(roundedRect:whiteContentView.bounds,
//                                byRoundingCorners:UIRectCorner(rawValue: UIRectCorner.bottomLeft.rawValue | UIRectCorner.bottomRight.rawValue),
//                                cornerRadii: CGSizeMake(6, 6))
//        let layer = CAShapeLayer()
//        layer.frame = whiteContentView.bounds
//        layer.path = path.cgPath
//        self.whiteContentView.layer.mask = layer
//    }
}
