//
//  YHSchemeTableHeadView.swift
//  galaxy
//
//  Created by EDY on 2024/3/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSchemeTableHeadView: UIView {
    var centerImageView: UIImageView!
    var centerView: UIView!
    var leftImageView: UIImageView!
    var rightImageView: UIImageView!
    var nameLabel: UILabel!
    var messageLabel: UILabel!
    var logoImageView: UIImageView!
    var titleView: UIView!
    var titleLabel: UILabel!
    var titleButton: UIButton!
    var scoreTotalView: YHSchemeHeadTotalScoreView!
    var scoreItemView: UIView!
    var dataSource: YHScemeHeadModel? {
        didSet {
            updateAllViews()
        }
    }
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(hex: 0x070E33)
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        centerImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "scheme_head_bg")
            return view
        }()
        addSubview(centerImageView)
        centerImageView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(416)
        }
        
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(8)
            make.right.equalTo(-8)
            make.top.equalTo(416)
            make.bottom.equalToSuperview()
        }
        
        leftImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "scheme_head_left")
            return view
        }()
        addSubview(leftImageView)
        leftImageView.snp.makeConstraints { make in
            make.left.equalTo(35)
            make.height.equalTo(80)
            make.width.equalTo(65)
            make.top.equalTo(27)
        }
        
        rightImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "scheme_head_right")
            return view
        }()
        addSubview(rightImageView)
        rightImageView.snp.makeConstraints { make in
            make.right.equalTo(-35)
            make.height.equalTo(80)
            make.width.equalTo(65)
            make.top.equalTo(27)
        }
        
        nameLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_B(ofSize: 24)
            label.textColor = UIColor(hex: 0xffffff)
            label.textAlignment = .center
            label.lineBreakMode = .byTruncatingMiddle
            label.text = "尊敬的--"
            return label
        }()
        addSubview(nameLabel)
        nameLabel.snp.makeConstraints { make in
            make.right.equalTo(-75)
            make.height.equalTo(33.5)
            make.left.equalTo(75)
            make.top.equalTo(26)
        }
        
        messageLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textColor = UIColor(hex: 0xffffff)
            label.textAlignment = .center
            label.numberOfLines = 0
            label.text = "您好，如电话沟通，这是我们为您定制的申请方案，方案详情如下："
            return label
        }()
        addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.right.equalTo(-75)
            make.height.equalTo(43)
            make.left.equalTo(75)
            make.top.equalTo(65.5)
        }
        
        logoImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "scheme_head_logo")
            return view
        }()
        addSubview(logoImageView)
        logoImageView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.height.equalTo(22)
            make.width.equalTo(58.5)
            make.top.equalTo(147)
        }
        
        titleView = {
            let view = UIView()
            view.backgroundColor = UIColor(hex: 0xd48638)
            return view
        }()
        addSubview(titleView)
        titleView.snp.makeConstraints { make in
            make.left.equalTo(28)
            make.top.equalTo(238.5)
            make.height.equalTo(16.5)
            make.width.equalTo(3.5)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = "综合评分"
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.centerY.equalTo(titleView.snp.centerY)
            make.left.equalTo(titleView.snp.right).offset(4)
            make.height.equalTo(24)
            make.width.equalTo(150)
        }
        
        titleButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 12)
            button.backgroundColor = UIColor(hex: 0xd48638).withAlphaComponent(0.08)
            button.contentHorizontalAlignment = .center
            button.setTitle("我的评分", for: .normal)
            button.setImage(UIImage(named: "scheme_button_icon"), for: .normal)
            button.setTitleColor(UIColor(hex: 0xd48638), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(goNext), for: .touchUpInside)
            return button
        }()
        addSubview(titleButton)
        titleButton.snp.makeConstraints { make in
            make.centerY.equalTo(titleView.snp.centerY)
            make.right.equalTo(-28)
            make.height.equalTo(27)
            make.width.equalTo(76)
        }
        titleButton.iconInRight(with: 2)

        scoreTotalView = {
            let view = YHSchemeHeadTotalScoreView()
            view.masksToBounds = true
            view.layer.cornerRadius = kCornerRadius4
            return view
        }()
        addSubview(scoreTotalView)
        scoreTotalView.snp.makeConstraints { make in
            make.top.equalTo(277)
            make.right.equalTo(-28)
            make.left.equalTo(28)
            make.height.equalTo(65)
        }
        
        scoreItemView = {
            let view = UIView()
            view.masksToBounds = true
            view.layer.cornerRadius = kCornerRadius4
            return view
        }()
        addSubview(scoreItemView)
        scoreItemView.snp.makeConstraints { make in
            make.top.equalTo(354)
            make.right.equalTo(-28)
            make.left.equalTo(28)
            make.bottom.equalToSuperview()
        }
    }
    
    func updateAllViews() {
        guard let model = dataSource else { return }
        nameLabel.text = "尊敬的" + model.name
        scoreTotalView.setScore(model.totalScore)
        scoreItemView.removeSubviews()
        for i in 0..<model.scoreArray.count {
            let string = model.scoreArray[i]
            let light = model.scoreLightArray[i]
            let view = YHSchemeHeadScoreItemView()
            view.setContent(string, light, model.addtionStr)
            scoreItemView.addSubview(view)
            view.snp.makeConstraints { make in
                make.top.equalTo(i * 28)
                make.left.right.equalToSuperview()
                make.height.equalTo(21)
            }
        }
    }
    
    @objc func goNext() {
        UIViewController.current?.navigationController?.pushViewController(YHScoreDetailViewController())
    }
}
