//
//  YHScoreDataModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHScoreDataModel: SmartCodable {
    var age_score: YHScoreSessionModel?
    var language_score: YHScoreSessionModel?
    var background_score: YHScoreSessionModel?
    var work_experience_score: YHScoreSessionModel?
    var education_score: YHScoreSessionModel?
    var talent_list_score: YHScoreSessionModel?
    
    required init() {
        
    }
    
    subscript(_ index: Int) -> YHScoreSessionModel? {
        if index == 1 {
            return age_score
        } else if index == 2 {
            return education_score
        } else if index == 3 {
            return work_experience_score
        } else if index == 4 {
            return talent_list_score
        } else if index == 5 {
            return language_score
        } else if index == 6 {
            return background_score
        }
        return nil
    }
}

class YHScoreOptiosModel: SmartCodable {
    var isSelected: Bool = false
    var scoreName: String = ""
    var scoreValue: String = ""
    
    required init() {
        
    }
}

class YHScoreSessionModel: SmartCodable {
    var name: String = "" // "年龄得分"
    var score: String = "" // （最高30分）
    var options: [YHScoreOptiosModel] = []
    var resultData: YHScoreResultBaseModel? {
        didSet {
            for (index, item) in options.enumerated() {
                if let model = resultData {
                    if model.answer.isEmpty == true {
                        item.isSelected = false
                    } else {
                        if model.answer.contains(String(index+1)) {
                            item.isSelected = true
                            continue
                        }
                    }
                }
                item.isSelected = false
            }
        }
    }
    required init() {
    }
}
