//
//  YHScoreItemCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHScoreItemCell: UITableViewCell {
    static let cellReuseIdentifier = "YHScoreItemCell"
    var optionData: YHScoreSessionModel? {
        didSet {
            updateUI()
        }
    }
    
    private lazy var holdView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        view.clipsToBounds = true
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var titleView: YHScoreTitleView!
}

extension YHScoreItemCell {
    func setupUI() {
        backgroundColor = .clear
        contentView.backgroundColor = .clear
    }
    
    func updateUI() {
        guard let arrData = optionData?.options else {
            return
        }
        holdView.removeSubviews()
        contentView.removeSubviews()
        
        contentView.addSubview(holdView)
        holdView.snp.makeConstraints { make in
            make.top.right.left.equalToSuperview()
            make.bottom.equalToSuperview().offset(-14)
        }
        
        titleView = YHScoreTitleView()
        holdView.addSubview(titleView)
        titleView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(YHScoreTitleView.viewH)
        }
        titleView.updateWith(optionData?.name, optionData?.score)
        
        let resultView = YHScoreResultView()
        holdView.addSubview(resultView)
        resultView.snp.makeConstraints { make in
            make.top.equalTo(titleView.snp.bottom)
            make.left.equalTo(titleView.snp.left)
            make.right.equalTo(titleView.snp.right)
            make.height.equalTo(YHScoreTitleView.viewH)
        }
        resultView.dataModel = optionData?.resultData
        
        var tagView: UIView = resultView
        for (index, item) in arrData.enumerated() {
            let optionView = YHScoreOptionsView()
            optionView.dataModel = item
            holdView.addSubview(optionView)
            if index == arrData.count - 1 {
                optionView.snp.makeConstraints { make in
                    make.top.equalTo(tagView.snp.bottom)
                    make.left.equalTo(titleView.snp.left)
                    make.right.equalTo(titleView.snp.right)
                    make.bottom.equalToSuperview()
                }
                optionView.bottomLine.isHidden = true
                
            } else {
                optionView.snp.makeConstraints { make in
                    make.top.equalTo(tagView.snp.bottom)
                    make.left.equalTo(titleView.snp.left)
                    make.right.equalTo(titleView.snp.right)
                }
                optionView.bottomLine.isHidden = false
            }
            
            tagView = optionView
        }
    }
}
