//
//  YHHKRecordItemDetailType.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

enum YHHKNonPresenceRecordType {
    case normal
    case over90
    case over180
    
    var title: String {
        switch self {
        case .over90:
            return "超90天未在港"
        case .over180:
            return "超180天未在港"
        case .normal:
            return ""
        }
    }
}

struct YHHKRecordsExpandedSection {
    let title: String
    let type: YHHKNonPresenceRecordType
    var isExpanded: Bool = true
    let summaryItems: [YHHKRecordItemDetailType]
    let periodItems: [YHHKRecordItemDetailType]
    
    var subItems: [YHHKRecordItemDetailType] {
        var retItems = [YHHKRecordItemDetailType]()
        retItems.append(contentsOf: summaryItems)
        if summaryItems.count > 0 {
            retItems.append(.occupyingSpace)
        }
        retItems.append(contentsOf: periodItems)
        if periodItems.count > 0 {
            retItems.append(.occupyingSpace)
        }
        return retItems
    }
}

enum YHHKRecordSectionType {
    case header(_ title: String)
    case expandedItem(_ model: YHHKRecordsExpandedSection)
}

enum YHHKRecordItemDetailType {
    case detailHeader(_ title: String)
    case lastStay(_ title: String)
    case summaryItem(_ title: String)
    case duration(_ from: String, _ to: String, _ total: String)
    case occupyingSpace
}
