//
//  YHHKRecordsDurationItemCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKRecordsDurationItemCell: YHHKRecordsSectionItemBaseCell {

    static let cellReuseIdentifier = "YHHKRecordsDurationItemCell"
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor70
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.font = .PFSC_R(ofSize: 14)
        return label
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String?, detail: String?, cellType: YHResignRoundCellType = .top) {
        infoTitleLabel.text = title
        infoDetailLabel.text = detail
        updateCellCorner(cellType)
        if cellType == .bottom {
            infoTitleLabel.snp.makeConstraints { make in
                make.left.equalToSuperview().offset(18)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.top.equalToSuperview().offset(8)
                make.bottom.equalToSuperview().offset(-16)
            }
        } else {
            infoTitleLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(18)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.top.equalToSuperview().offset(8)
                make.bottom.equalToSuperview().offset(-8)
            }
        }
    }
    
}

extension YHHKRecordsDurationItemCell {
    
    private func setupUI() {
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        infoTitleLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.right.lessThanOrEqualToSuperview().offset(-18)
            make.top.equalToSuperview().offset(8)
            make.bottom.equalToSuperview().offset(-8)
        }
        infoDetailLabel.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-14)
            make.centerY.equalTo(infoTitleLabel)
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(14)
        }
    }
}
