//
//  YHHKRecordsLastStayCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKRecordsLastStayCell: YHHKRecordsSectionItemBaseCell {

    static let cellReuseIdentifier = "YHHKRecordsLastStayCell"
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor50
        return label
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String?, cellType: YHResignRoundCellType = .top) {
        infoTitleLabel.text = title
        updateCellCorner(cellType)
    }
    
}

extension YHHKRecordsLastStayCell {
    
    private func setupUI() {
        subContainerView.addSubview(infoTitleLabel)
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.right.lessThanOrEqualToSuperview().offset(-18)
            make.top.equalToSuperview().offset(12)
            make.bottom.equalToSuperview().offset(-8)
        }
    }
}
