//
//  YHHKRecordsOccupyingSpaceCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKRecordsOccupyingSpaceCell: UITableViewCell {

    static let cellReuseIdentifier = "YHHKRecordsOccupyingSpaceCell"
    
    private lazy var subContainerView: YHBaseDynamicCornerRadiusView = {
        let view = YHBaseDynamicCornerRadiusView(cornerRadius: 8, corner: .none)
        view.backgroundColor = .white
        return view
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.isHidden = true
        view.backgroundColor = .separatorColor
        return view
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(_ isShowBottomLine: Bool = false, isBottom: Bool = false) {
        bottomLineView.isHidden = !isShowBottomLine
        subContainerView.corner = isBottom ? [.bottomLeft, .bottomRight] : .none
    }
}

extension YHHKRecordsOccupyingSpaceCell {
    
    private func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.addSubview(subContainerView)
        subContainerView.addSubview(bottomLineView)
        
        subContainerView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        bottomLineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(0.5)
        }
    }
}
