//
//  YHHKRecordsPersonnelSelectCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKRecordsPersonnelSelectCell: UICollectionViewCell {
    static let cellReuseIdentifier = "YHHKRecordsPersonnelSelectCell"
    
    static let cellHeight: CGFloat = 32
    static let offsetX: CGFloat = 10
    static let labelFont = UIFont.PFSC_R(ofSize: 13)
    
    let defaultBgColor: UIColor = .contentBkgColor
    let defaultFontColor: UIColor = .mainTextColor
    
    let selectedBgColor: UIColor = .brandMainColor8
    let selectedFontColor: UIColor = .brandMainColor
    let selectedBorderColor: UIColor = .brandMainColor
    
    private lazy var backCover: YHBaseCornerRadiusBorderView = {
        let view = YHBaseCornerRadiusBorderView(cornerRadius: 3, corner: .allCorners, lineWidth: nil, lineColor: selectedBorderColor.cgColor)
        view.backgroundColor = defaultBgColor
        return view
    }()
    
    private lazy var tagLabel: UILabel = {
        let label = UILabel(frame: CGRect.zero)
        label.textColor = defaultFontColor
        label.font = YHHKRecordsPersonnelSelectCell.labelFont
        label.textAlignment = .center
        label.lineBreakMode = .byTruncatingTail
        return label
    }()
    
    private lazy var selctedBadgeIcon: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "personnel_selected_badge")
        view.isHidden = true
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        configViews()
    }
    
    override var isSelected: Bool {
        didSet {
            if isSelected {
                backCover.backgroundColor = selectedBgColor
                tagLabel.textColor = selectedFontColor
                backCover.lineWidth = 1
                selctedBadgeIcon.isHidden = false
            } else {
                backCover.backgroundColor = defaultBgColor
                tagLabel.textColor = defaultFontColor
                backCover.lineWidth = nil
                selctedBadgeIcon.isHidden = true
            }
        }
    }
    
    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func configViews() {
        contentView.addSubview(backCover)
        backCover.addSubview(tagLabel)
        backCover.addSubview(selctedBadgeIcon)
        
        backCover.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        tagLabel.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.centerX.equalToSuperview()
            make.left.greaterThanOrEqualToSuperview().offset(YHHKRecordsPersonnelSelectCell.offsetX)
            make.right.lessThanOrEqualToSuperview().offset(-YHHKRecordsPersonnelSelectCell.offsetX)
        }
        selctedBadgeIcon.snp.makeConstraints { make in
            make.bottom.right.equalToSuperview()
            make.width.height.equalTo(14)
        }
    }
    
    func setupCellInfo(_ text: String?) {
        tagLabel.text = text
        // self.isSelected = isSelected
    }
    
}
