//
//  YHHKImmigrationRecordsViewModel.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/23.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKImmigrationRecordsViewModel: YHBaseViewModel {
    
    func getStayInHKRecordStatistics(orderId: Int, callback: @escaping (_ recordStatistics: YHHKImmigrationRecordsStatisticsModel?, _ error: YHErrorModel?) -> Void) {
        let params = ["order_id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.HKImmigrationRecords.stayInHKRecordStatistics
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHHKImmigrationRecordsStatisticsModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                callback(resultModel, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }
            
        } failBlock: { err in
            callback(nil, err)
        }
    }

    func getHKImmigrationRecordsSummary(orderId: Int, callback: @escaping (_ recordsSummary: YHHKImmigrationRecordsSummaryModel?, _ error: YHErrorModel?) -> Void) {
        let params = ["order_id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.HKImmigrationRecords.stayInHKRecordSummary
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHHKImmigrationRecordsSummaryModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                callback(resultModel, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }
            
        } failBlock: { err in
            callback(nil, err)
        }
    }
    
    func getHKImmigrationRecordsSingle(orderId: Int, userType: Int, callback: @escaping (_ recordsSingleModel: YHHKImmigrationRecordsSingleModel?, _ error: YHErrorModel?) -> Void) {
        let params = ["order_id": orderId, "user_type": userType]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.HKImmigrationRecords.stayInHKRecordSingle
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHHKImmigrationRecordsSingleModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                callback(resultModel, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }
            
        } failBlock: { err in
            callback(nil, err)
        }
    }
    
    func getHKImmigrationRecordsFamilyMembers(orderId: Int, callback: @escaping (_ familyMembers: YHHKRecordsFamilyMembers?, _ error: YHErrorModel?) -> Void) {
        let params = ["order_id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.HKImmigrationRecords.stayInHKRecordFamilyMembers
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHHKRecordsFamilyMembers.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                callback(resultModel, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }
            
        } failBlock: { err in
            callback(nil, err)
        }
    }
    
    func addHKImmigrationRecord(_ params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.HKImmigrationRecords.addStayInHKRecord
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func editHKImmigrationRecord(_ params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.HKImmigrationRecords.editStayInHKRecord
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }

}
