//
//  YHVisaRenewalTroubleshootingGuideVC.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHVisaRenewalTroubleshootingGuideVC: YHBaseViewController {
    
    enum TableRow {
        case header
        case tips(_ title: String, _ detail: ASAttributedString)
        case workflow(_ title: String, _ workflows: [String])
    }
    
    private lazy var bgIcon: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "resign_visa_guide_bg")
        return view
    }()
    
    private lazy var tableView: UITableView = {
        let view = UITableView(frame: .zero, style: .plain)
        view.backgroundColor = .clear
        view.separatorStyle = .none
        view.rowHeight = UITableView.automaticDimension
        view.estimatedRowHeight = 52.0
        view.dataSource = self
        view.delegate = self
        view.showsVerticalScrollIndicator = false
        view.register(YHVisaRenewalTroubleshootingGuideHeaderCell.self, forCellReuseIdentifier: YHVisaRenewalTroubleshootingGuideHeaderCell.cellReuseIdentifier)
        view.register(YHVisaRenewalWorkflowCell.self, forCellReuseIdentifier: YHVisaRenewalWorkflowCell.cellReuseIdentifier)
        view.register(YHVisaRenewalGuideTipsCell.self, forCellReuseIdentifier: YHVisaRenewalGuideTipsCell.cellReuseIdentifier)
        
        return view
    }()
    
    private lazy var sureButton: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
        button.setTitle("我知道了", for: .normal)
        button.setTitle("我知道了", for: .highlighted)
        button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
        button.setTitleColor( UIColor(hex: 0xffffff), for: .highlighted)
        button.setTitleColor( UIColor(hex: 0xffffff), for: .disabled)
        button.addTarget(self, action: #selector(clickSureButton), for: .touchUpInside)
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.backgroundColor = .brandMainColor
        return button
    }()
    
    private lazy var bottomView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()
    
    var sureButtonEvent: (() -> Void)?
    
    private lazy var datas: [TableRow] = []
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        setupDatas()
    }

}

extension YHVisaRenewalTroubleshootingGuideVC {
    
    @objc private func clickSureButton() {
        sureButtonEvent?()
    }
    
    private func setupUI() {
        gk_navBarAlpha = 0
        gk_navigationBar.isHidden = true
        view.backgroundColor = UIColor.white
        view.addSubview(bgIcon)
        view.addSubview(tableView)
        view.addSubview(bottomView)
        bottomView.addSubview(sureButton)
        bgIcon.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(bgIcon.snp.width).multipliedBy(1)
        }
        
        bottomView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalTo(view.safeAreaLayoutGuide.snp.bottom)
            make.height.equalTo(64)
        }
        
        sureButton.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(kMargin)
            make.right.equalToSuperview().offset(-kMargin)
            make.centerY.equalToSuperview()
            make.height.equalTo(48)
        }
        
        tableView.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.right.equalToSuperview()
            make.top.equalToSuperview().offset(20)
            make.bottom.equalTo(bottomView.snp.top)
        }
        tableView.tableFooterView = UIView(frame: CGRect.init(x: 0, y: 0, width: KScreenWidth, height: 24))
        preferredContentSize = CGSize(width: KScreenWidth, height: KScreenHeight - k_Height_NavigationtBarAndStatuBar)
    }
    
    private func setupDatas() {
        datas.append(.header)
        
        let firstAtt: ASAttributedString = .init(string: "将军澳出入境大厅(将军澳宝邑路61号，港铁将军澳B出口，或调景岭A2出口)", .font(UIFont.PFSC_R(ofSize: 13)), .foreground(UIColor.mainTextColor70), .paragraph(.lineHeightMultiple(1.07)))
        datas.append(.tips("办理地址：", firstAtt))
        
        let secAtt: ASAttributedString = .init(string: "有效旅行证件原件、香港身份证原件、获批函", .font(UIFont.PFSC_R(ofSize: 13)), .foreground(UIColor.mainTextColor70), .paragraph(.lineHeightMultiple(1.07)))
        datas.append(.tips("携带资料：", secAtt))
        
        datas.append(.workflow("操作流程：", ["将军澳出入境6楼接待窗口取号", "等待叫号，告知主任需要缴费查看签证，等待主任核实", "若核实是以访客身份入境，现场写一份声明解释为何没有及时回港", "等待重发，预计3-6周，重发期间可以先离开香港", "重发后再持有效申请旅行证件入境香港后线上缴费"]))
        
        let fourthAtt: ASAttributedString = .init(string: "1、可尝试现场和主任说明为何不能长期待在香港的原因，争取能够直接签证缴费，比如两地都有业务需要自己处理\n\n2、如验证码失效、网页加载无法接入确认缴费页面，请退出后检查网络后重新操作\n\n3、如缴费提示正在有一笔付款进行中要隔1个小时后再重新进到网页操作", .font(UIFont.PFSC_R(ofSize: 13)), .foreground(UIColor.mainTextColor70), .paragraph(.lineHeightMultiple(1.07)))
        datas.append(.tips("注意事项：", fourthAtt))
        tableView.reloadData()
    }
}

extension YHVisaRenewalTroubleshootingGuideVC: UITableViewDelegate, UITableViewDataSource {
    func numberOfSections(in tableView: UITableView) -> Int {
        return datas.count > 0 ? 1 : 0
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return datas.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        guard datas.count > indexPath.row else {
            return UITableViewCell()
        }
        let tableRow = datas[indexPath.row]
        switch tableRow {
        case .header:
            if let cell = tableView.dequeueReusableCell(withIdentifier: YHVisaRenewalTroubleshootingGuideHeaderCell.cellReuseIdentifier) as? YHVisaRenewalTroubleshootingGuideHeaderCell {
                return cell
            }
        case let .tips(title, detail):
            if let cell = tableView.dequeueReusableCell(withIdentifier: YHVisaRenewalGuideTipsCell.cellReuseIdentifier) as? YHVisaRenewalGuideTipsCell {
                cell.setupCellInfo(title: title, detail: detail)
                return cell
            }
        case let .workflow(title, workflows):
            if let cell = tableView.dequeueReusableCell(withIdentifier: YHVisaRenewalWorkflowCell.cellReuseIdentifier) as? YHVisaRenewalWorkflowCell {
                cell.setupCellInfo(title: title, workflows: workflows)
                return cell
            }
        }
        return UITableViewCell()
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
}
